/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph.disk;

import io.github.jbellis.jvector.annotations.VisibleForTesting;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.disk.Feature;
import io.github.jbellis.jvector.graph.disk.FeatureId;
import io.github.jbellis.jvector.graph.disk.FeatureSource;
import io.github.jbellis.jvector.graph.disk.FusedADC;
import io.github.jbellis.jvector.graph.disk.Header;
import io.github.jbellis.jvector.graph.disk.InlineVectors;
import io.github.jbellis.jvector.graph.disk.OnDiskGraphIndexWriter;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.VectorizationProvider;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import io.github.jbellis.jvector.vector.types.VectorTypeSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class OnDiskGraphIndex
implements GraphIndex,
AutoCloseable,
Accountable {
    public static final int CURRENT_VERSION = 3;
    static final int MAGIC = -62111;
    static final VectorTypeSupport vectorTypeSupport = VectorizationProvider.getInstance().getVectorTypeSupport();
    final ReaderSupplier readerSupplier;
    final int version;
    final int size;
    final int maxDegree;
    final int dimension;
    final int entryNode;
    final int inlineBlockSize;
    final EnumMap<FeatureId, ? extends Feature> features;
    final EnumMap<FeatureId, Integer> inlineOffsets;
    private final long neighborsOffset;

    OnDiskGraphIndex(ReaderSupplier readerSupplier, Header header, long neighborsOffset) {
        this.readerSupplier = readerSupplier;
        this.version = header.common.version;
        this.size = header.common.size;
        this.dimension = header.common.dimension;
        this.entryNode = header.common.entryNode;
        this.maxDegree = header.common.maxDegree;
        this.features = header.features;
        this.neighborsOffset = neighborsOffset;
        int inlineBlockSize = 0;
        this.inlineOffsets = new EnumMap(FeatureId.class);
        for (Map.Entry<FeatureId, ? extends Feature> entry : this.features.entrySet()) {
            this.inlineOffsets.put(entry.getKey(), inlineBlockSize);
            inlineBlockSize += entry.getValue().inlineSize();
        }
        this.inlineBlockSize = inlineBlockSize;
    }

    public static OnDiskGraphIndex load(ReaderSupplier readerSupplier, long offset) {
        OnDiskGraphIndex onDiskGraphIndex;
        block8: {
            RandomAccessReader reader = readerSupplier.get();
            try {
                Header header = Header.load(reader, offset);
                onDiskGraphIndex = new OnDiskGraphIndex(readerSupplier, header, reader.getPosition());
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error initializing OnDiskGraph at offset " + offset, e);
                }
            }
            reader.close();
        }
        return onDiskGraphIndex;
    }

    public static OnDiskGraphIndex load(ReaderSupplier readerSupplier) {
        return OnDiskGraphIndex.load(readerSupplier, 0L);
    }

    public Set<FeatureId> getFeatureSet() {
        return this.features.keySet();
    }

    public int getDimension() {
        return this.dimension;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int maxDegree() {
        return this.maxDegree;
    }

    @Override
    public NodesIterator getNodes() {
        return NodesIterator.fromPrimitiveIterator(IntStream.range(0, this.size).iterator(), this.size);
    }

    @Override
    public long ramBytesUsed() {
        return (long)(32 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + 2L * (long)RamUsageEstimator.NUM_BYTES_OBJECT_REF * (long)FeatureId.values().length;
    }

    @Override
    public void close() throws IOException {
        this.readerSupplier.close();
    }

    public String toString() {
        return String.format("OnDiskGraphIndex(size=%d, entryPoint=%d, features=%s)", this.size, this.entryNode, this.features.keySet().stream().map(Enum::name).collect(Collectors.joining(",")));
    }

    @Override
    public View getView() {
        try {
            return new View(this.readerSupplier.get());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(GraphIndex graph, RandomAccessVectorValues vectors, Path path) throws IOException {
        OnDiskGraphIndex.write(graph, vectors, OnDiskGraphIndexWriter.sequentialRenumbering(graph), path);
    }

    public static void write(GraphIndex graph, RandomAccessVectorValues vectors, Map<Integer, Integer> oldToNewOrdinals, Path path) throws IOException {
        try (OnDiskGraphIndexWriter writer = new OnDiskGraphIndexWriter.Builder(graph, path).withMap(oldToNewOrdinals).with(new InlineVectors(vectors.dimension())).build();){
            EnumMap<FeatureId, IntFunction<Feature.State>> suppliers = Feature.singleStateFactory(FeatureId.INLINE_VECTORS, nodeId -> new InlineVectors.State(vectors.getVector(nodeId)));
            writer.write(suppliers);
        }
    }

    @VisibleForTesting
    static boolean areHeadersEqual(OnDiskGraphIndex g1, OnDiskGraphIndex g2) {
        return g1.version == g2.version && g1.size == g2.size && g1.maxDegree == g2.maxDegree && g1.dimension == g2.dimension && g1.entryNode == g2.entryNode;
    }

    public class View
    implements FeatureSource,
    GraphIndex.ScoringView,
    RandomAccessVectorValues {
        protected final RandomAccessReader reader;
        private final int[] neighbors;

        public View(RandomAccessReader reader) {
            this.reader = reader;
            this.neighbors = new int[OnDiskGraphIndex.this.maxDegree];
        }

        @Override
        public int dimension() {
            return OnDiskGraphIndex.this.dimension;
        }

        @Override
        public boolean isValueShared() {
            return false;
        }

        @Override
        public RandomAccessVectorValues copy() {
            throw new UnsupportedOperationException();
        }

        protected long inlineOffsetFor(int node, FeatureId featureId) {
            return OnDiskGraphIndex.this.neighborsOffset + (long)node * (4L + (long)OnDiskGraphIndex.this.inlineBlockSize + 4L * (long)(OnDiskGraphIndex.this.maxDegree + 1)) + 4L + (long)OnDiskGraphIndex.this.inlineOffsets.get((Object)featureId).intValue();
        }

        long neighborsOffsetFor(int node) {
            return OnDiskGraphIndex.this.neighborsOffset + (long)(node + 1) * (4L + (long)OnDiskGraphIndex.this.inlineBlockSize) + (long)node * 4L * (long)(OnDiskGraphIndex.this.maxDegree + 1);
        }

        @Override
        public RandomAccessReader inlineReaderForNode(int node, FeatureId featureId) throws IOException {
            long offset = this.inlineOffsetFor(node, featureId);
            this.reader.seek(offset);
            return this.reader;
        }

        @Override
        public VectorFloat<?> getVector(int node) {
            if (!OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                throw new UnsupportedOperationException("No inline vectors in this graph");
            }
            try {
                long offset = this.inlineOffsetFor(node, FeatureId.INLINE_VECTORS);
                this.reader.seek(offset);
                return vectorTypeSupport.readFloatVector(this.reader, OnDiskGraphIndex.this.dimension);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void getVectorInto(int node, VectorFloat<?> vector, int offset) {
            if (!OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                throw new UnsupportedOperationException("No inline vectors in this graph");
            }
            try {
                long diskOffset = this.inlineOffsetFor(node, FeatureId.INLINE_VECTORS);
                this.reader.seek(diskOffset);
                vectorTypeSupport.readFloatVector(this.reader, OnDiskGraphIndex.this.dimension, vector, offset);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            try {
                this.reader.seek(this.neighborsOffsetFor(node));
                int neighborCount = this.reader.readInt();
                assert (neighborCount <= OnDiskGraphIndex.this.maxDegree) : String.format("Node %d neighborCount %d > M %d", node, neighborCount, OnDiskGraphIndex.this.maxDegree);
                this.reader.read(this.neighbors, 0, neighborCount);
                return new NodesIterator.ArrayNodesIterator(this.neighbors, neighborCount);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int size() {
            return OnDiskGraphIndex.this.size;
        }

        @Override
        public int entryNode() {
            return OnDiskGraphIndex.this.entryNode;
        }

        @Override
        public Bits liveNodes() {
            return Bits.ALL;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        public ScoreFunction.Reranker rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf, Set<FeatureId> permissibleFeatures) {
            if (permissibleFeatures.contains((Object)FeatureId.INLINE_VECTORS) && OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.INLINE_VECTORS)) {
                return ScoreFunction.Reranker.from(queryVector, vsf, this);
            }
            throw new UnsupportedOperationException("No reranker available for this graph");
        }

        @Override
        public ScoreFunction.Reranker rerankerFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            return this.rerankerFor(queryVector, vsf, FeatureId.ALL);
        }

        @Override
        public ScoreFunction.ApproximateScoreFunction approximateScoreFunctionFor(VectorFloat<?> queryVector, VectorSimilarityFunction vsf) {
            if (OnDiskGraphIndex.this.features.containsKey((Object)FeatureId.FUSED_ADC)) {
                return ((FusedADC)OnDiskGraphIndex.this.features.get((Object)FeatureId.FUSED_ADC)).approximateScoreFunctionFor(queryVector, vsf, this, this.rerankerFor(queryVector, vsf));
            }
            throw new UnsupportedOperationException("No approximate score function available for this graph");
        }
    }
}

