/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.annotations.Experimental;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodeQueue;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.NodesUnsorted;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.graph.ScoreTracker;
import io.github.jbellis.jvector.graph.SearchResult;
import io.github.jbellis.jvector.graph.similarity.ScoreFunction;
import io.github.jbellis.jvector.graph.similarity.SearchScoreProvider;
import io.github.jbellis.jvector.util.Bits;
import io.github.jbellis.jvector.util.BoundedLongHeap;
import io.github.jbellis.jvector.util.GrowableLongHeap;
import io.github.jbellis.jvector.util.SparseBits;
import io.github.jbellis.jvector.vector.VectorSimilarityFunction;
import io.github.jbellis.jvector.vector.types.VectorFloat;
import java.io.Closeable;
import java.io.IOException;
import org.agrona.collections.IntHashSet;

public class GraphSearcher
implements Closeable {
    private final GraphIndex.View view;
    private final NodeQueue candidates;
    private final NodeQueue approximateResults;
    private final NodeQueue rerankedResults;
    private final IntHashSet visited;
    private final NodesUnsorted evictedResults;
    private Bits acceptOrds;
    private SearchScoreProvider scoreProvider;

    public GraphSearcher(GraphIndex graph) {
        this(graph.getView());
    }

    private GraphSearcher(GraphIndex.View view) {
        this.view = view;
        this.candidates = new NodeQueue(new GrowableLongHeap(100), NodeQueue.Order.MAX_HEAP);
        this.evictedResults = new NodesUnsorted(100);
        this.approximateResults = new NodeQueue(new BoundedLongHeap(100), NodeQueue.Order.MIN_HEAP);
        this.rerankedResults = new NodeQueue(new BoundedLongHeap(100), NodeQueue.Order.MIN_HEAP);
        this.visited = new IntHashSet();
    }

    public GraphIndex.View getView() {
        return this.view;
    }

    public static SearchResult search(VectorFloat<?> queryVector, int topK, RandomAccessVectorValues vectors, VectorSimilarityFunction similarityFunction, GraphIndex graph, Bits acceptOrds) {
        SearchResult searchResult;
        GraphSearcher searcher = new GraphSearcher(graph);
        try {
            SearchScoreProvider ssp = SearchScoreProvider.exact(queryVector, similarityFunction, vectors);
            searchResult = searcher.search(ssp, topK, acceptOrds);
        }
        catch (Throwable throwable) {
            try {
                try {
                    searcher.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        searcher.close();
        return searchResult;
    }

    @Experimental
    public SearchResult search(SearchScoreProvider scoreProvider, int topK, int rerankK, float threshold, float rerankFloor, Bits acceptOrds) {
        return this.searchInternal(scoreProvider, topK, rerankK, threshold, rerankFloor, this.view.entryNode(), acceptOrds);
    }

    public SearchResult search(SearchScoreProvider scoreProvider, int topK, float threshold, Bits acceptOrds) {
        return this.search(scoreProvider, topK, topK, threshold, 0.0f, acceptOrds);
    }

    public SearchResult search(SearchScoreProvider scoreProvider, int topK, Bits acceptOrds) {
        return this.search(scoreProvider, topK, 0.0f, acceptOrds);
    }

    SearchResult searchInternal(SearchScoreProvider scoreProvider, int topK, int rerankK, float threshold, float rerankFloor, int ep, Bits rawAcceptOrds) {
        if (rawAcceptOrds == null) {
            throw new IllegalArgumentException("Use MatchAllBits to indicate that all ordinals are accepted, instead of null");
        }
        if (rerankK < topK) {
            throw new IllegalArgumentException(String.format("rerankK %d must be >= topK %d", rerankK, topK));
        }
        this.scoreProvider = scoreProvider;
        this.acceptOrds = Bits.intersectionOf(rawAcceptOrds, this.view.liveNodes());
        this.evictedResults.clear();
        this.candidates.clear();
        this.visited.clear();
        if (ep < 0) {
            return new SearchResult(new SearchResult.NodeScore[0], 0, Float.POSITIVE_INFINITY);
        }
        float score = scoreProvider.scoreFunction().similarityTo(ep);
        this.visited.add(ep);
        this.candidates.push(ep, score);
        return this.resume(1, topK, rerankK, threshold, rerankFloor);
    }

    private SearchResult resume(int initialVisited, int topK, int rerankK, float threshold, float rerankFloor) {
        try {
            NodeQueue popFromQueue;
            float worstApproximateInTopK;
            float topCandidateScore;
            assert (this.approximateResults.size() == 0);
            assert (this.rerankedResults.size() == 0);
            this.approximateResults.setMaxSize(rerankK);
            this.rerankedResults.setMaxSize(topK);
            int numVisited = initialVisited;
            float minAcceptedSimilarity = Float.NEGATIVE_INFINITY;
            ScoreTracker scoreTracker = threshold > 0.0f ? new ScoreTracker.TwoPhaseTracker(threshold) : ScoreTracker.NO_OP;
            VectorFloat<?> similarities = null;
            Bits previouslyEvicted = this.evictedResults.size() > 0 ? new SparseBits() : Bits.NONE;
            this.evictedResults.foreach((node, score) -> {
                this.candidates.push(node, score);
                ((SparseBits)previouslyEvicted).set(node);
            });
            this.evictedResults.clear();
            while (this.candidates.size() > 0 && !((topCandidateScore = this.candidates.topScore()) < minAcceptedSimilarity) && !scoreTracker.shouldStop()) {
                int topCandidateNode = this.candidates.pop();
                if (this.acceptOrds.get(topCandidateNode) && topCandidateScore >= threshold) {
                    boolean added;
                    if (this.approximateResults.size() < rerankK) {
                        this.approximateResults.push(topCandidateNode, topCandidateScore);
                        added = true;
                    } else if (topCandidateScore > this.approximateResults.topScore()) {
                        int evictedNode = this.approximateResults.topNode();
                        float evictedScore = this.approximateResults.topScore();
                        this.evictedResults.add(evictedNode, evictedScore);
                        this.approximateResults.push(topCandidateNode, topCandidateScore);
                        added = true;
                    } else {
                        added = false;
                    }
                    if (added && this.approximateResults.size() >= rerankK) {
                        minAcceptedSimilarity = this.approximateResults.topScore();
                    }
                }
                if (previouslyEvicted.get(topCandidateNode)) continue;
                ScoreFunction scoreFunction = this.scoreProvider.scoreFunction();
                boolean useEdgeLoading = scoreFunction.supportsEdgeLoadingSimilarity();
                if (useEdgeLoading) {
                    similarities = scoreFunction.edgeLoadingSimilarityTo(topCandidateNode);
                }
                NodesIterator it = this.view.getNeighborsIterator(topCandidateNode);
                for (int i = 0; i < it.size(); ++i) {
                    int friendOrd = it.nextInt();
                    if (!this.visited.add(friendOrd)) continue;
                    ++numVisited;
                    float friendSimilarity = useEdgeLoading ? similarities.get(i) : scoreFunction.similarityTo(friendOrd);
                    scoreTracker.track(friendSimilarity);
                    this.candidates.push(friendOrd, friendSimilarity);
                }
            }
            assert (this.approximateResults.size() <= rerankK);
            if (this.scoreProvider.reranker() == null) {
                while (this.approximateResults.size() > topK) {
                    float nScore = this.approximateResults.topScore();
                    int n = this.approximateResults.pop();
                    this.evictedResults.add(n, nScore);
                }
                worstApproximateInTopK = Float.POSITIVE_INFINITY;
                popFromQueue = this.approximateResults;
            } else {
                worstApproximateInTopK = this.approximateResults.rerank(topK, this.scoreProvider.reranker(), rerankFloor, this.rerankedResults, this.evictedResults);
                this.approximateResults.clear();
                popFromQueue = this.rerankedResults;
            }
            assert (popFromQueue.size() <= topK);
            SearchResult.NodeScore[] nodes = new SearchResult.NodeScore[popFromQueue.size()];
            for (int i = nodes.length - 1; i >= 0; --i) {
                float nScore = popFromQueue.topScore();
                int n = popFromQueue.pop();
                nodes[i] = new SearchResult.NodeScore(n, nScore);
            }
            assert (popFromQueue.size() == 0);
            return new SearchResult(nodes, numVisited, worstApproximateInTopK);
        }
        catch (Throwable t) {
            this.approximateResults.clear();
            this.rerankedResults.clear();
            throw t;
        }
    }

    @Experimental
    public SearchResult resume(int additionalK, int rerankK) {
        return this.resume(0, additionalK, rerankK, 0.0f, 0.0f);
    }

    @Override
    public void close() throws IOException {
        this.view.close();
    }

    @Deprecated
    public static class Builder {
        private final GraphIndex.View view;

        public Builder(GraphIndex.View view) {
            this.view = view;
        }

        public Builder withConcurrentUpdates() {
            return this;
        }

        public GraphSearcher build() {
            return new GraphSearcher(this.view);
        }
    }
}

