/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.vector;

import io.github.jbellis.jvector.util.RamUsageEstimator;
import io.github.jbellis.jvector.vector.types.ByteSequence;
import java.util.Arrays;

public final class ArrayByteSequence
implements ByteSequence<byte[]> {
    private final byte[] data;

    ArrayByteSequence(int length) {
        this.data = new byte[length];
    }

    ArrayByteSequence(byte[] data) {
        this.data = data;
    }

    @Override
    public byte[] get() {
        return this.data;
    }

    @Override
    public byte get(int n) {
        return this.data[n];
    }

    @Override
    public void set(int n, byte value) {
        this.data[n] = value;
    }

    @Override
    public void zero() {
        Arrays.fill(this.data, (byte)0);
    }

    @Override
    public int length() {
        return this.data.length;
    }

    public ArrayByteSequence copy() {
        return new ArrayByteSequence(Arrays.copyOf(this.data, this.data.length));
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.sizeOf(this.data) + RamUsageEstimator.shallowSizeOfInstance(ByteSequence.class);
    }

    @Override
    public void copyFrom(ByteSequence<?> src, int srcOffset, int destOffset, int length) {
        ArrayByteSequence csrc = (ArrayByteSequence)src;
        System.arraycopy(csrc.data, srcOffset, this.data, destOffset, length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < Math.min(this.data.length, 25); ++i) {
            sb.append(this.data[i]);
            if (i >= this.data.length - 1) continue;
            sb.append(", ");
        }
        if (this.data.length > 25) {
            sb.append("...");
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ArrayByteSequence that = (ArrayByteSequence)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }
}

