/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.util;

import java.util.Objects;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class PoolingSupport<T> {
    public static <T> PoolingSupport<T> newThreadBased(Supplier<T> initialValue) {
        return new ThreadPooling<T>(initialValue);
    }

    public static <T> PoolingSupport<T> newNoPooling(T fixedValue) {
        return new NoPooling<T>(fixedValue);
    }

    public static <T> PoolingSupport<T> newQueuePooling(int limit, Supplier<T> initialValue) {
        return new QueuedPooling<T>(limit, initialValue);
    }

    private PoolingSupport() {
    }

    public abstract Pooled<T> get();

    public abstract Stream<T> stream();

    protected abstract void onClosed(Pooled<T> var1);

    static final class ThreadPooling<T>
    extends PoolingSupport<T> {
        private final ThreadLocal<Pooled<T>> threadLocal;
        private final Supplier<T> initialValue;

        private ThreadPooling(Supplier<T> initialValue) {
            this.initialValue = initialValue;
            this.threadLocal = new ThreadLocal();
        }

        @Override
        public Pooled<T> get() {
            Pooled<T> val = this.threadLocal.get();
            if (val != null) {
                return val;
            }
            val = new Pooled<T>(this, this.initialValue.get());
            this.threadLocal.set(val);
            return val;
        }

        @Override
        public Stream<T> stream() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void onClosed(Pooled<T> value) {
        }
    }

    static final class NoPooling<T>
    extends PoolingSupport<T> {
        private final T value;
        private final Pooled<T> staticPooled;

        private NoPooling(T value) {
            this.value = value;
            this.staticPooled = new Pooled<T>(this, this.value);
        }

        @Override
        public Pooled<T> get() {
            return this.staticPooled;
        }

        @Override
        public Stream<T> stream() {
            return Stream.of(this.value);
        }

        @Override
        protected void onClosed(Pooled<T> value) {
        }
    }

    static final class QueuedPooling<T>
    extends PoolingSupport<T> {
        private final int limit;
        private final AtomicInteger created;
        private final LinkedBlockingQueue<Pooled<T>> queue;
        private final Supplier<T> initialValue;

        private QueuedPooling(int limit, Supplier<T> initialValue) {
            this.limit = limit;
            this.created = new AtomicInteger(0);
            this.queue = new LinkedBlockingQueue(limit);
            this.initialValue = initialValue;
        }

        @Override
        public Pooled<T> get() {
            Pooled<T> t = this.queue.poll();
            if (t != null) {
                return t;
            }
            if (this.created.incrementAndGet() > this.limit) {
                this.created.decrementAndGet();
                throw new IllegalStateException("Number of outstanding pooled objects has gone beyond the limit of " + this.limit);
            }
            return new Pooled<T>(this, this.initialValue.get());
        }

        @Override
        public Stream<T> stream() {
            if (this.queue.size() < this.created.get()) {
                throw new IllegalStateException("close() was not called on all pooled objects yet");
            }
            return this.queue.stream().filter(Objects::nonNull).map(Pooled::get);
        }

        @Override
        protected void onClosed(Pooled<T> value) {
            this.queue.offer(value);
        }
    }

    public static final class Pooled<T>
    implements AutoCloseable {
        private final T value;
        private final PoolingSupport<T> owner;

        private Pooled(PoolingSupport<T> owner, T value) {
            this.owner = owner;
            this.value = value;
        }

        public T get() {
            return this.value;
        }

        @Override
        public void close() {
            this.owner.onClosed(this);
        }
    }
}

