/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.NodeSimilarity;
import io.github.jbellis.jvector.graph.SearchResult;
import io.github.jbellis.jvector.util.AbstractLongHeap;
import io.github.jbellis.jvector.util.NumericUtils;

public class NodeQueue {
    private final AbstractLongHeap heap;
    private final Order order;
    private boolean incomplete;

    public NodeQueue(AbstractLongHeap heap, Order order) {
        this.heap = heap;
        this.order = order;
    }

    public int size() {
        return this.heap.size();
    }

    public boolean push(int newNode, float newScore) {
        return this.heap.push(this.encode(newNode, newScore));
    }

    private long encode(int node, float score) {
        return this.order.apply((long)NumericUtils.floatToSortableInt(score) << 32 | 0xFFFFFFFFL & (long)(~node));
    }

    private float decodeScore(long heapValue) {
        return NumericUtils.sortableIntToFloat((int)(this.order.apply(heapValue) >> 32));
    }

    private int decodeNodeId(long heapValue) {
        return (int)(this.order.apply(heapValue) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public int pop() {
        return this.decodeNodeId(this.heap.pop());
    }

    public int[] nodesCopy() {
        int size = this.size();
        int[] nodes = new int[size];
        for (int i = 0; i < size; ++i) {
            nodes[i] = this.decodeNodeId(this.heap.get(i + 1));
        }
        return nodes;
    }

    public SearchResult.NodeScore[] nodesCopy(NodeSimilarity.ExactScoreFunction sf) {
        int size = this.size();
        SearchResult.NodeScore[] ns = new SearchResult.NodeScore[size];
        for (int i = 0; i < size; ++i) {
            int node = this.decodeNodeId(this.heap.get(i + 1));
            ns[i] = new SearchResult.NodeScore(node, sf.similarityTo(node));
        }
        return ns;
    }

    public int topNode() {
        return this.decodeNodeId(this.heap.top());
    }

    public float topScore() {
        return this.decodeScore(this.heap.top());
    }

    public void clear() {
        this.heap.clear();
        this.incomplete = false;
    }

    public boolean incomplete() {
        return this.incomplete;
    }

    public void markIncomplete() {
        this.incomplete = true;
    }

    public String toString() {
        return "Nodes[" + this.heap.size() + "]";
    }

    public static enum Order {
        MIN_HEAP{

            @Override
            long apply(long v) {
                return v;
            }
        }
        ,
        MAX_HEAP{

            @Override
            long apply(long v) {
                return -1L - v;
            }
        };


        abstract long apply(long var1);
    }
}

