/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.disk;

import io.github.jbellis.jvector.disk.Io;
import io.github.jbellis.jvector.disk.RandomAccessReader;
import io.github.jbellis.jvector.disk.ReaderSupplier;
import io.github.jbellis.jvector.graph.GraphIndex;
import io.github.jbellis.jvector.graph.NodesIterator;
import io.github.jbellis.jvector.graph.OnHeapGraphIndex;
import io.github.jbellis.jvector.graph.RandomAccessVectorValues;
import io.github.jbellis.jvector.util.Accountable;
import io.github.jbellis.jvector.util.Bits;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;

public class OnDiskGraphIndex<T>
implements GraphIndex<T>,
AutoCloseable,
Accountable {
    private final ReaderSupplier readerSupplier;
    private final long neighborsOffset;
    private final int size;
    private final int entryNode;
    private final int maxDegree;
    private final int dimension;

    public OnDiskGraphIndex(ReaderSupplier readerSupplier, long offset) {
        this.readerSupplier = readerSupplier;
        this.neighborsOffset = offset + 16L;
        try (RandomAccessReader reader = readerSupplier.get();){
            reader.seek(offset);
            this.size = reader.readInt();
            this.dimension = reader.readInt();
            this.entryNode = reader.readInt();
            this.maxDegree = reader.readInt();
        }
        catch (Exception e) {
            throw new RuntimeException("Error initializing OnDiskGraph at offset " + offset, e);
        }
    }

    public static <T> Map<Integer, Integer> getSequentialRenumbering(GraphIndex<T> graph) {
        HashMap<Integer, Integer> hashMap;
        block9: {
            GraphIndex.View<T> view = graph.getView();
            try {
                HashMap<Integer, Integer> oldToNewMap = new HashMap<Integer, Integer>();
                int nextOrdinal = 0;
                for (int i = 0; i < view.getIdUpperBound(); ++i) {
                    if (!graph.containsNode(i)) continue;
                    oldToNewMap.put(i, nextOrdinal++);
                }
                hashMap = oldToNewMap;
                if (view == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (view != null) {
                        try {
                            view.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            view.close();
        }
        return hashMap;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int maxDegree() {
        return this.maxDegree;
    }

    public OnDiskView getView() {
        return new OnDiskView(this.readerSupplier.get());
    }

    @Override
    public NodesIterator getNodes() {
        return NodesIterator.fromPrimitiveIterator(IntStream.range(0, this.size).iterator(), this.size);
    }

    @Override
    public long ramBytesUsed() {
        return 24L;
    }

    @Override
    public void close() throws IOException {
        this.readerSupplier.close();
    }

    public static <T> void write(GraphIndex<T> graph, RandomAccessVectorValues<T> vectors, DataOutput out) throws IOException {
        try (GraphIndex.View<T> view = graph.getView();){
            if (view.getIdUpperBound() > graph.size()) {
                throw new IllegalArgumentException("Graph contains deletes, must specify oldToNewOrdinals map");
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        OnDiskGraphIndex.write(graph, vectors, OnDiskGraphIndex.getSequentialRenumbering(graph), out);
    }

    public static <T> void write(GraphIndex<T> graph, RandomAccessVectorValues<T> vectors, Map<Integer, Integer> oldToNewOrdinals, DataOutput out) throws IOException {
        OnHeapGraphIndex ohgi;
        if (graph instanceof OnHeapGraphIndex && (ohgi = (OnHeapGraphIndex)graph).getDeletedNodes().cardinality() > 0) {
            throw new IllegalArgumentException("Run builder.cleanup() before writing the graph");
        }
        if (oldToNewOrdinals.size() != graph.size()) {
            throw new IllegalArgumentException(String.format("ordinalMapper size %d does not match graph size %d", oldToNewOrdinals.size(), graph.size()));
        }
        ArrayList<Map.Entry<Integer, Integer>> entriesByNewOrdinal = new ArrayList<Map.Entry<Integer, Integer>>(oldToNewOrdinals.entrySet());
        entriesByNewOrdinal.sort(Comparator.comparingInt(Map.Entry::getValue));
        if (graph.size() > 0 && entriesByNewOrdinal.get(entriesByNewOrdinal.size() - 1).getValue() != graph.size() - 1) {
            throw new IllegalArgumentException("oldToNewOrdinals produced out-of-range entries");
        }
        try (GraphIndex.View<T> view = graph.getView();){
            out.writeInt(graph.size());
            out.writeInt(vectors.dimension());
            out.writeInt(view.entryNode());
            out.writeInt(graph.maxDegree());
            for (int i = 0; i < oldToNewOrdinals.size(); ++i) {
                int n;
                Map.Entry<Integer, Integer> entry = entriesByNewOrdinal.get(i);
                int originalOrdinal = entry.getKey();
                int newOrdinal = entry.getValue();
                if (!graph.containsNode(originalOrdinal)) continue;
                out.writeInt(newOrdinal);
                Io.writeFloats(out, (float[])vectors.vectorValue(originalOrdinal));
                NodesIterator neighbors = view.getNeighborsIterator(originalOrdinal);
                out.writeInt(neighbors.size());
                for (n = 0; n < neighbors.size(); ++n) {
                    out.writeInt(oldToNewOrdinals.get(neighbors.nextInt()));
                }
                assert (!neighbors.hasNext());
                while (n < graph.maxDegree()) {
                    out.writeInt(-1);
                    ++n;
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public class OnDiskView
    implements GraphIndex.View<T>,
    AutoCloseable {
        private final RandomAccessReader reader;
        private final int[] neighbors;

        public OnDiskView(RandomAccessReader reader) {
            this.reader = reader;
            this.neighbors = new int[OnDiskGraphIndex.this.maxDegree];
        }

        @Override
        public T getVector(int node) {
            try {
                long offset = OnDiskGraphIndex.this.neighborsOffset + (long)node * (4L + (long)OnDiskGraphIndex.this.dimension * 4L + 4L * (long)(OnDiskGraphIndex.this.maxDegree + 1)) + 4L;
                float[] vector = new float[OnDiskGraphIndex.this.dimension];
                this.reader.seek(offset);
                this.reader.readFully(vector);
                return vector;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public NodesIterator getNeighborsIterator(int node) {
            try {
                this.reader.seek(OnDiskGraphIndex.this.neighborsOffset + (long)(node + 1) * (4L + (long)OnDiskGraphIndex.this.dimension * 4L) + (long)node * 4L * (long)(OnDiskGraphIndex.this.maxDegree + 1));
                int neighborCount = this.reader.readInt();
                assert (neighborCount <= OnDiskGraphIndex.this.maxDegree) : String.format("neighborCount %d > M %d", neighborCount, OnDiskGraphIndex.this.maxDegree);
                this.reader.read(this.neighbors, 0, neighborCount);
                return new NodesIterator.ArrayNodesIterator(this.neighbors, neighborCount);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public int size() {
            return OnDiskGraphIndex.this.size();
        }

        @Override
        public int entryNode() {
            return OnDiskGraphIndex.this.entryNode;
        }

        @Override
        public Bits liveNodes() {
            return Bits.ALL;
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

