/*
 * Decompiled with CFR 0.152.
 */
package io.github.jbellis.jvector.graph;

import io.github.jbellis.jvector.graph.NodesIterator;
import java.util.Arrays;

public interface GraphIndex<T> {
    public int size();

    public NodesIterator getNodes();

    public View<T> getView();

    public int maxEdgesPerNode();

    public static <T> String prettyPrint(GraphIndex<T> graph) {
        StringBuilder sb = new StringBuilder();
        sb.append(graph);
        sb.append("\n");
        View<T> view = graph.getView();
        NodesIterator it = graph.getNodes();
        while (it.hasNext()) {
            int node = it.nextInt();
            sb.append("  ").append(node).append(" -> ");
            NodesIterator neighbors = view.getNeighborsIterator(node);
            while (neighbors.hasNext()) {
                sb.append(" ").append(neighbors.nextInt());
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static interface View<T> {
        public NodesIterator getNeighborsIterator(int var1);

        public int size();

        public int entryNode();

        public T getVector(int var1);

        default public int[] getSortedNodes() {
            int[] sortedNodes = new int[this.size()];
            Arrays.setAll(sortedNodes, i -> i);
            return sortedNodes;
        }

        default public int getNeighborCount(int node) {
            return this.getNeighborsIterator(node).size();
        }
    }
}

