/*
 * Decompiled with CFR 0.152.
 */
package com.github.jbellis.jvector.graph;

import com.github.jbellis.jvector.annotations.VisibleForTesting;
import com.github.jbellis.jvector.util.ArrayUtil;
import java.util.Arrays;

public class NeighborArray {
    protected final boolean scoresDescOrder;
    protected int size;
    float[] score;
    int[] node;

    public NeighborArray(int maxSize, boolean descOrder) {
        this.node = new int[maxSize];
        this.score = new float[maxSize];
        this.scoresDescOrder = descOrder;
    }

    public void addInOrder(int newNode, float newScore) {
        if (this.size == this.node.length) {
            this.node = ArrayUtil.grow(this.node);
            this.score = ArrayUtil.growExact(this.score, this.node.length);
        }
        if (this.size > 0) {
            float previousScore = this.score[this.size - 1];
            assert (this.scoresDescOrder && previousScore >= newScore || !this.scoresDescOrder && previousScore <= newScore) : "Nodes are added in the incorrect order! Comparing " + newScore + " to " + Arrays.toString(ArrayUtil.copyOfSubArray(this.score, 0, this.size));
        }
        this.node[this.size] = newNode;
        this.score[this.size] = newScore;
        ++this.size;
    }

    public void insertSorted(int newNode, float newScore) {
        if (this.size == this.node.length) {
            this.growArrays();
        }
        int insertionPoint = this.scoresDescOrder ? this.descSortFindRightMostInsertionPoint(newScore) : this.ascSortFindRightMostInsertionPoint(newScore);
        System.arraycopy(this.node, insertionPoint, this.node, insertionPoint + 1, this.size - insertionPoint);
        System.arraycopy(this.score, insertionPoint, this.score, insertionPoint + 1, this.size - insertionPoint);
        this.node[insertionPoint] = newNode;
        this.score[insertionPoint] = newScore;
        ++this.size;
    }

    protected final void growArrays() {
        this.node = ArrayUtil.grow(this.node);
        this.score = ArrayUtil.growExact(this.score, this.node.length);
    }

    public int size() {
        return this.size;
    }

    public int[] node() {
        return this.node;
    }

    public float[] score() {
        return this.score;
    }

    public void clear() {
        this.size = 0;
    }

    public void removeLast() {
        --this.size;
    }

    public void removeIndex(int idx) {
        System.arraycopy(this.node, idx + 1, this.node, idx, this.size - idx - 1);
        System.arraycopy(this.score, idx + 1, this.score, idx, this.size - idx - 1);
        --this.size;
    }

    public String toString() {
        return "NeighborArray[" + this.size + "]";
    }

    protected final int ascSortFindRightMostInsertionPoint(float newScore) {
        int insertionPoint = Arrays.binarySearch(this.score, 0, this.size, newScore);
        if (insertionPoint >= 0) {
            while (insertionPoint < this.size - 1 && this.score[insertionPoint + 1] == this.score[insertionPoint]) {
                ++insertionPoint;
            }
            ++insertionPoint;
        } else {
            insertionPoint = -insertionPoint - 1;
        }
        return insertionPoint;
    }

    protected final int descSortFindRightMostInsertionPoint(float newScore) {
        int start = 0;
        int end = this.size - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.score[mid] < newScore) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    @VisibleForTesting
    boolean contains(int node) {
        for (int i = 0; i < this.size; ++i) {
            if (this.node[i] != node) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    int[] copyDenseNodes() {
        return Arrays.copyOf(this.node, this.size);
    }
}

