/*
 * Decompiled with CFR 0.152.
 */
package io.github.interestinglab.waterdrop.common.config;

import io.github.interestinglab.waterdrop.common.config.ConfigRuntimeException;
import io.github.interestinglab.waterdrop.config.Config;
import io.github.interestinglab.waterdrop.config.ConfigFactory;
import io.github.interestinglab.waterdrop.config.ConfigValue;
import java.util.LinkedHashMap;
import java.util.Map;

public class TypesafeConfigUtils {
    public static Config extractSubConfig(Config source, String prefix, boolean keepPrefix) {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        for (Map.Entry<String, ConfigValue> entry : source.entrySet()) {
            String key = entry.getKey();
            String value = String.valueOf(entry.getValue().unwrapped());
            if (!key.startsWith(prefix)) continue;
            if (keepPrefix) {
                values.put(key, value);
                continue;
            }
            values.put(key.substring(prefix.length()), value);
        }
        return ConfigFactory.parseMap(values);
    }

    public static boolean hasSubConfig(Config source, String prefix) {
        boolean hasConfig = false;
        for (Map.Entry<String, ConfigValue> entry : source.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            hasConfig = true;
            break;
        }
        return hasConfig;
    }

    public static Config extractSubConfigThrowable(Config source, String prefix, boolean keepPrefix) {
        Config config = TypesafeConfigUtils.extractSubConfig(source, prefix, keepPrefix);
        if (config.isEmpty()) {
            throw new ConfigRuntimeException("config is empty");
        }
        return config;
    }
}

