/*
 * Decompiled with CFR 0.152.
 */
package io.github.interestinglab.waterdrop.config;

import io.github.interestinglab.waterdrop.config.Config;
import io.github.interestinglab.waterdrop.config.ConfigException;
import io.github.interestinglab.waterdrop.config.ConfigFactory;
import io.github.interestinglab.waterdrop.config.ConfigLoadingStrategy;
import io.github.interestinglab.waterdrop.config.ConfigParseOptions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class DefaultConfigLoadingStrategy
implements ConfigLoadingStrategy {
    @Override
    public Config parseApplicationConfig(ConfigParseOptions parseOptions) {
        String url;
        String file;
        ClassLoader loader = parseOptions.getClassLoader();
        if (loader == null) {
            throw new ConfigException.BugOrBroken("ClassLoader should have been set here; bug in ConfigFactory. (You can probably work around this bug by passing in a class loader or calling currentThread().setContextClassLoader() though.)");
        }
        int specified = 0;
        String resource = System.getProperty("config.resource");
        if (resource != null) {
            ++specified;
        }
        if ((file = System.getProperty("config.file")) != null) {
            ++specified;
        }
        if ((url = System.getProperty("config.url")) != null) {
            ++specified;
        }
        if (specified == 0) {
            return ConfigFactory.parseResourcesAnySyntax("application", parseOptions);
        }
        if (specified > 1) {
            throw new ConfigException.Generic("You set more than one of config.file='" + file + "', config.url='" + url + "', config.resource='" + resource + "'; don't know which one to use!");
        }
        ConfigParseOptions overrideOptions = parseOptions.setAllowMissing(false);
        if (resource != null) {
            if (resource.startsWith("/")) {
                resource = resource.substring(1);
            }
            return ConfigFactory.parseResources(loader, resource, overrideOptions);
        }
        if (file != null) {
            return ConfigFactory.parseFile(new File(file), overrideOptions);
        }
        try {
            return ConfigFactory.parseURL(new URL(url), overrideOptions);
        }
        catch (MalformedURLException e) {
            throw new ConfigException.Generic("Bad URL in config.url system property: '" + url + "': " + e.getMessage(), e);
        }
    }
}

