/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.daypickerlibrary.views;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.support.v7.content.res.AppCompatResources;
import com.github.informramiz.daypickerlibrary.R;
import com.github.informramiz.daypickerlibrary.common.CommonUtils;

public class CustomStateListDrawable
extends StateListDrawable {
    private Context context;

    public CustomStateListDrawable(@NonNull Context context) {
        this.context = context;
        GradientDrawable normalGradientDrawable = this.getNormalGradientDrawable();
        GradientDrawable selectedGradientDrawable = this.getSelectedGradientDrawable();
        GradientDrawable pressedGradientDrawable = this.getPressedGradientDrawable();
        this.addState(new int[]{0x10100A1}, (Drawable)selectedGradientDrawable);
        this.addState(new int[]{16842919}, (Drawable)pressedGradientDrawable);
        this.addState(new int[]{-16842913, -16842919}, (Drawable)normalGradientDrawable);
    }

    public boolean isStateful() {
        return true;
    }

    private Context getContext() {
        return this.context;
    }

    private GradientDrawable getNormalGradientDrawable() {
        GradientDrawable gradientDrawable = (GradientDrawable)AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.shape_circle_holo);
        gradientDrawable.setStroke(this.getContext().getResources().getDimensionPixelSize(R.dimen.circle_stroke_width), this.getColorAccent());
        return gradientDrawable;
    }

    private GradientDrawable getSelectedGradientDrawable() {
        GradientDrawable gradientDrawable = (GradientDrawable)AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.shape_circle_filled);
        gradientDrawable.setColor(this.getColorAccent());
        return gradientDrawable;
    }

    private GradientDrawable getPressedGradientDrawable() {
        GradientDrawable gradientDrawable = (GradientDrawable)AppCompatResources.getDrawable((Context)this.getContext(), (int)R.drawable.shape_circle_filled_light);
        gradientDrawable.setColor(this.getColorHighlight());
        return gradientDrawable;
    }

    @ColorInt
    private int getColorAccent() {
        return ContextCompat.getColor((Context)this.getContext(), (int)CommonUtils.resolveResource(this.getContext(), R.attr.colorAccent));
    }

    @ColorInt
    private int getColorHighlight() {
        return ContextCompat.getColor((Context)this.getContext(), (int)CommonUtils.resolveResource(this.getContext(), R.attr.colorControlHighlight));
    }
}

