/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.daypickerlibrary.views;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatTextView;
import android.util.AttributeSet;
import android.view.View;
import com.github.informramiz.daypickerlibrary.R;

public class CircularTextView
extends AppCompatTextView
implements View.OnClickListener {
    @Nullable
    private View.OnClickListener onClickListener = null;
    private boolean isAutoSelectEnabled = true;

    public CircularTextView(Context context) {
        super(context);
        this.init();
    }

    public CircularTextView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public CircularTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public void init() {
        this.setGravity(17);
        this.setBackgroundResource(R.drawable.circular_button_selector);
        super.setOnClickListener((View.OnClickListener)this);
    }

    public boolean isAutoSelectEnabled() {
        return this.isAutoSelectEnabled;
    }

    public void setAutoSelectEnabled(boolean autoSelectEnabled) {
        this.isAutoSelectEnabled = autoSelectEnabled;
    }

    public void onClick(View v) {
        if (this.isAutoSelectEnabled()) {
            this.handleAutoSelectEvent();
        }
        if (this.onClickListener != null) {
            this.onClickListener.onClick(v);
        }
    }

    private void handleAutoSelectEvent() {
        this.setSelected(!this.isSelected());
        this.updateTextColor();
    }

    private void updateTextColor() {
        if (this.isSelected()) {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)0x1060001));
        } else {
            this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)17170441));
        }
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        this.updateTextColor();
    }

    public void setOnClickListener(@Nullable View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }
}

