/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.androidfilepickerlibrary;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.github.informramiz.androidfilepickerlibrary.utils.FileUtils;
import java.util.Locale;

public class FileInfo
implements Parcelable {
    public static final Parcelable.Creator<FileInfo> CREATOR = new Parcelable.Creator<FileInfo>(){

        public FileInfo createFromParcel(Parcel in) {
            return new FileInfo(in);
        }

        public FileInfo[] newArray(int size) {
            return new FileInfo[size];
        }
    };
    @Nullable
    private String path;
    private String name;
    private String type;
    private String extension;
    private Long size;
    private String uri;

    public FileInfo() {
    }

    protected FileInfo(Parcel in) {
        this.path = in.readString();
        this.name = in.readString();
        this.type = in.readString();
        this.extension = in.readString();
        this.size = in.readLong();
        this.uri = in.readString();
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Uri getUri() {
        if (this.uri != null) {
            return Uri.parse((String)this.uri);
        }
        return null;
    }

    public void setUri(Uri uri) {
        this.uri = uri.toString();
    }

    public boolean isFileValid() {
        return this.getPath() != null || this.getUri() != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public boolean isDocument() {
        return FileUtils.isDocFile(this.getExtension(), this.getType());
    }

    public boolean isImage() {
        return FileUtils.isImageAttachment(this.getExtension(), this.getType());
    }

    public boolean isVideo() {
        return FileUtils.isVideoAttachment(this.getExtension(), this.getType());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.path);
        dest.writeString(this.name);
        dest.writeString(this.type);
        dest.writeString(this.extension);
        dest.writeLong(this.size != null ? this.size : 0L);
        dest.writeString(this.uri);
    }

    public String toString() {
        return String.format(Locale.US, "FileInfo: {path=%s, uri=%s, name=%s, type=%s, extension=%s, size=%d}", this.path, this.uri, this.name, this.type, this.extension, this.size);
    }
}

