/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.androidfilepickerlibrary;

import android.content.Context;
import android.content.DialogInterface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.AlertDialog;
import com.github.informramiz.androidfilepickerlibrary.R;

public class CameraAttachmentPickerDialog {
    private AlertDialog.Builder builder;
    @Nullable
    private OnOptionSelectedListener onOptionSelectedListener;

    public CameraAttachmentPickerDialog(@NonNull Context context) {
        this.builder = new AlertDialog.Builder(context);
    }

    public void setTitle(String title) {
        this.builder.setTitle((CharSequence)title);
    }

    public void showCameraDialog() {
        CharSequence[] choices = new String[]{this.builder.getContext().getResources().getString(R.string.file_picker_take_picture), this.builder.getContext().getResources().getString(R.string.file_picker_record_video)};
        this.builder.setItems(choices, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (CameraAttachmentPickerDialog.this.onOptionSelectedListener == null) {
                    return;
                }
                switch (which) {
                    case 0: {
                        CameraAttachmentPickerDialog.this.onOptionSelectedListener.onImageOptionSelected();
                        break;
                    }
                    case 1: {
                        CameraAttachmentPickerDialog.this.onOptionSelectedListener.onVideoOptionSelected();
                    }
                }
            }
        });
        this.builder.show();
    }

    public void setOnOptionSelectedListener(@Nullable OnOptionSelectedListener onOptionSelectedListener) {
        this.onOptionSelectedListener = onOptionSelectedListener;
    }

    public static interface OnOptionSelectedListener {
        public void onImageOptionSelected();

        public void onVideoOptionSelected();
    }
}

