/*
 * Decompiled with CFR 0.152.
 */
package com.github.informramiz.androidfilepickerlibrary;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.v7.app.AppCompatActivity;
import android.widget.Toast;
import com.github.informramiz.androidfilepickerlibrary.Attach;
import com.github.informramiz.androidfilepickerlibrary.FilePicker;
import com.github.informramiz.androidfilepickerlibrary.FilePickerCustomFileProvider;
import com.github.informramiz.androidfilepickerlibrary.R;
import com.github.informramiz.androidfilepickerlibrary.utils.CommonUtils;
import com.github.informramiz.androidfilepickerlibrary.utils.FileUtils;
import com.github.informramiz.androidfilepickerlibrary.utils.LogUtils;
import droidninja.filepicker.FilePickerBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AttachmentPickerActivity
extends AppCompatActivity {
    private static final String TAG = AttachmentPickerActivity.class.getSimpleName();
    private static final String[] GALLERY_ATTACHMENT_MIME_TYPES = new String[]{"image/*", "video/*"};
    private static final String[] DOC_ATTACHMENT_MIME_TYPES = new String[]{"text/*", "application/*"};
    private static final String[] AUDIO_ATTACHMENT_MIME_TYPES = new String[]{"audio/*"};
    private static final String MAIN_MIME_TYPE_GALLERY_ATTACHMENT = "video/*,image/*";
    private static final String MAIN_MIME_TYPE_DOC_ATTACHMENT = "*/*";
    private static final String MAIN_MIME_TYPE_AUDIO_ATTACHMENT = "*/*";
    public static final String DATA_ATTACHMENT = "attachment";
    public static final String EXTRA_ATTACHMENT_TYPE = "attachmentType";
    public static final int ATTACHMENT_TYPE_GALLERY = 0;
    public static final int ATTACHMENT_TYPE_DOC = 1;
    public static final int ATTACHMENT_TYPE_CAPTURE_FROM_CAMERA = 2;
    public static final int ATTACHMENT_TYPE_PICK_AUDIO = 3;
    public static final String EXTRA_CAPTURE_TYPE = "capture_type";
    public static final int CAPTURE_TYPE_IMAGE = 0;
    public static final int CAPTURE_TYPE_VIDEO = 1;
    public static final int REQ_CODE_CAPTURE_IMAGE = 2;
    public static final int REQ_CODE_CAPTURE_VIDEO = 3;
    public static final int REQ_CODE_SELECT_ATTACHMENT = 4;
    public static final int REQ_CODE_SELECT_ATTACHMENT_FOR_API_BELOW_21 = 5;
    public static final int REQ_CODE_SELECT_ATTACHMENT_BY_LIBRARY = 6;
    private Attach captureFromCameraAttachment;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        int attachmentType = this.getIntent().getIntExtra(EXTRA_ATTACHMENT_TYPE, 0);
        switch (attachmentType) {
            case 0: {
                this.handleGalleryAttachment();
                break;
            }
            case 1: {
                this.handleDocAttachment();
                break;
            }
            case 2: {
                this.handleCameraAttachment();
                break;
            }
            case 3: {
                this.handleAudioAttachment();
            }
        }
    }

    @RequiresApi(api=19)
    private void showFileChooser(@NonNull String mainMimeType, @Nullable String[] mimeTypes) {
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.setType(mainMimeType);
        intent.addCategory("android.intent.category.OPENABLE");
        intent.putExtra("android.intent.extra.LOCAL_ONLY", true);
        if (mimeTypes != null) {
            intent.putExtra("android.intent.extra.MIME_TYPES", mimeTypes);
        }
        this.startActivityForResult(intent, 4);
    }

    private void handleCameraAttachment() {
        int captureType = this.getIntent().getIntExtra(EXTRA_CAPTURE_TYPE, 0);
        this.captureFromCameraAttachment = captureType == 1 ? this.launchCameraVideoIntent() : this.launchCameraImageIntent();
    }

    private Attach launchCameraVideoIntent() {
        Intent recordVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (recordVideoIntent.resolveActivity(this.getPackageManager()) == null) {
            CommonUtils.showFeatureNotSupportedToast((Context)this);
            return null;
        }
        File file = FileUtils.createVideoFile((Context)this);
        if (file == null) {
            CommonUtils.showMessageSafe((Context)this, R.string.error_msg_file_creation_failed);
            return null;
        }
        Uri contentUri = FilePickerCustomFileProvider.getUriForFile((Context)this, (String)"nullcom.github.informramiz.androidfilepickerlibrary.fileprovider", (File)file);
        recordVideoIntent.addFlags(3);
        if (!this.isApiLollipopOrAbove()) {
            List resolveInfoList = this.getPackageManager().queryIntentActivities(recordVideoIntent, 65536);
            for (ResolveInfo resolveInfo : resolveInfoList) {
                this.grantUriPermission(resolveInfo.activityInfo.packageName, contentUri, 3);
            }
        }
        recordVideoIntent.putExtra("output", (Parcelable)contentUri);
        this.startActivityForResult(recordVideoIntent, 3);
        Attach attach = FilePicker.convertFileToAttachment(file);
        attach.setUri(contentUri);
        return attach;
    }

    @Nullable
    private Attach launchCameraImageIntent() {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.getPackageManager()) == null) {
            CommonUtils.showFeatureNotSupportedToast((Context)this);
            return null;
        }
        File photoFile = FileUtils.createImageFile((Context)this);
        if (photoFile == null) {
            CommonUtils.showMessageSafe((Context)this, R.string.error_msg_file_creation_failed);
            return null;
        }
        Uri contentUri = FilePickerCustomFileProvider.getUriForFile((Context)this, (String)"nullcom.github.informramiz.androidfilepickerlibrary.fileprovider", (File)photoFile);
        takePictureIntent.addFlags(3);
        if (!this.isApiLollipopOrAbove()) {
            List resolveInfoList = this.getPackageManager().queryIntentActivities(takePictureIntent, 65536);
            for (ResolveInfo resolveInfo : resolveInfoList) {
                this.grantUriPermission(resolveInfo.activityInfo.packageName, contentUri, 3);
            }
        }
        takePictureIntent.putExtra("output", (Parcelable)contentUri);
        this.startActivityForResult(takePictureIntent, 2);
        Attach attach = FilePicker.convertFileToAttachment(photoFile);
        attach.setUri(contentUri);
        return attach;
    }

    private void handleAudioAttachment() {
        if (this.isApiLollipopOrAbove()) {
            this.showFileChooser("*/*", AUDIO_ATTACHMENT_MIME_TYPES);
        } else {
            Intent intent = new Intent("android.intent.action.PICK", MediaStore.Audio.Media.EXTERNAL_CONTENT_URI);
            if (intent.resolveActivity(this.getPackageManager()) == null) {
                Toast.makeText((Context)this, (int)R.string.error_msg_please_install_file_manager, (int)1).show();
                return;
            }
            this.startActivityForResult(intent, 5);
        }
    }

    private void handleGalleryAttachment() {
        if (this.isApiLollipopOrAbove()) {
            this.showFileChooser("*/*", GALLERY_ATTACHMENT_MIME_TYPES);
        } else {
            Intent intent = new Intent("android.intent.action.PICK");
            intent.setType(MAIN_MIME_TYPE_GALLERY_ATTACHMENT);
            if (intent.resolveActivity(this.getPackageManager()) == null) {
                Toast.makeText((Context)this, (int)R.string.error_msg_please_install_file_manager, (int)1).show();
                return;
            }
            this.startActivityForResult(intent, 5);
        }
    }

    private void handleDocAttachment() {
        if (this.isApiLollipopOrAbove()) {
            this.showFileChooser("*/*", DOC_ATTACHMENT_MIME_TYPES);
        } else {
            FilePickerBuilder.getInstance().setMaxCount(1).enableCameraSupport(false).setActivityTheme(R.style.LibAppTheme).pickFile((Activity)this, 6);
        }
    }

    private boolean isApiLollipopOrAbove() {
        return Build.VERSION.SDK_INT >= 21;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        Intent dataIntent = new Intent();
        if (resultCode != -1) {
            this.setResult(resultCode, dataIntent);
            this.finish();
            return;
        }
        Attach attachment = null;
        if (requestCode == 2 || requestCode == 3) {
            FileUtils.addFileToGallery((Activity)this, this.captureFromCameraAttachment.getPath());
            attachment = this.captureFromCameraAttachment;
        } else if (requestCode == 4 || requestCode == 5) {
            attachment = this.onNativeFilePickerActivityResult(this.getApplicationContext(), data);
        } else if (requestCode == 6) {
            attachment = this.onFilePickerLibraryActivityResult(data);
        }
        dataIntent.putExtra(DATA_ATTACHMENT, (Parcelable)attachment);
        this.setResult(-1, dataIntent);
        this.finish();
    }

    private Attach onNativeFilePickerActivityResult(Context context, Intent data) {
        Uri uri = data.getData();
        if (this.isApiLollipopOrAbove()) {
            this.takePersistablePermissions(context, data, uri);
        }
        LogUtils.i(TAG, "Uri received from File picker: " + uri.toString());
        LogUtils.i(TAG, "Path received from File picker: " + uri.getPath());
        Attach attach = FilePicker.extractAttachInfoFromUri(context, uri);
        LogUtils.i(TAG, attach.toString());
        return attach;
    }

    private Attach onFilePickerLibraryActivityResult(Intent data) {
        ArrayList paths = data.getStringArrayListExtra("SELECTED_DOCS");
        String path = (String)paths.get(0);
        Attach attach = FilePicker.convertFileToAttachment(path);
        return attach;
    }

    @RequiresApi(api=19)
    private void takePersistablePermissions(Context context, Intent data, Uri uri) {
        try {
            int flags = data.getFlags() & 3;
            context.getContentResolver().takePersistableUriPermission(uri, flags);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

