/*
 * Decompiled with CFR 0.152.
 */
package io.github.inflationx.viewpump;

import android.util.Log;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionUtils {
    private static final String TAG = ReflectionUtils.class.getSimpleName();

    static Field getField(Class clazz, String fieldName) {
        try {
            Field f = clazz.getDeclaredField(fieldName);
            f.setAccessible(true);
            return f;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
    }

    static Object getValue(Field field, Object obj) {
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    static void setValue(Field field, Object obj, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static Method getMethod(Class clazz, String methodName) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    public static void invokeMethod(Object object, Method method, Object ... args) {
        try {
            if (method == null) {
                return;
            }
            method.invoke(object, args);
        }
        catch (IllegalAccessException e) {
            Log.d((String)TAG, (String)"Can't access method using reflection", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.d((String)TAG, (String)"Can't invoke method using reflection", (Throwable)e);
        }
    }
}

