/*
 * Decompiled with CFR 0.152.
 */
package com.ablanco.zoomy;

import android.app.Activity;
import android.app.Dialog;
import android.app.DialogFragment;
import android.view.View;
import android.view.animation.Interpolator;
import com.ablanco.zoomy.ActivityContainer;
import com.ablanco.zoomy.DialogContainer;
import com.ablanco.zoomy.DialogFragmentContainer;
import com.ablanco.zoomy.DoubleTapListener;
import com.ablanco.zoomy.LongPressListener;
import com.ablanco.zoomy.TapListener;
import com.ablanco.zoomy.TargetContainer;
import com.ablanco.zoomy.ZoomListener;
import com.ablanco.zoomy.ZoomableTouchListener;
import com.ablanco.zoomy.ZoomyConfig;

public class Zoomy {
    private static ZoomyConfig mDefaultConfig = new ZoomyConfig();

    private Zoomy() {
    }

    public static void setDefaultConfig(ZoomyConfig config) {
        mDefaultConfig = config;
    }

    public static void unregister(View view) {
        view.setOnTouchListener(null);
    }

    public static class Builder {
        private boolean mDisposed = false;
        private ZoomyConfig mConfig;
        private TargetContainer mTargetContainer;
        private View mTargetView;
        private ZoomListener mZoomListener;
        private Interpolator mZoomInterpolator;
        private TapListener mTapListener;
        private LongPressListener mLongPressListener;
        private DoubleTapListener mdDoubleTapListener;

        public Builder(Activity activity) {
            this.mTargetContainer = new ActivityContainer(activity);
        }

        public Builder(Dialog dialog) {
            this.mTargetContainer = new DialogContainer(dialog);
        }

        public Builder(DialogFragment dialogFragment) {
            this.mTargetContainer = new DialogFragmentContainer(dialogFragment);
        }

        public Builder target(View target) {
            this.mTargetView = target;
            return this;
        }

        public Builder animateZooming(boolean animate) {
            this.checkNotDisposed();
            if (this.mConfig == null) {
                this.mConfig = new ZoomyConfig();
            }
            this.mConfig.setZoomAnimationEnabled(animate);
            return this;
        }

        public Builder enableImmersiveMode(boolean enable) {
            this.checkNotDisposed();
            if (this.mConfig == null) {
                this.mConfig = new ZoomyConfig();
            }
            this.mConfig.setImmersiveModeEnabled(enable);
            return this;
        }

        public Builder interpolator(Interpolator interpolator) {
            this.checkNotDisposed();
            this.mZoomInterpolator = interpolator;
            return this;
        }

        public Builder zoomListener(ZoomListener listener) {
            this.checkNotDisposed();
            this.mZoomListener = listener;
            return this;
        }

        public Builder tapListener(TapListener listener) {
            this.checkNotDisposed();
            this.mTapListener = listener;
            return this;
        }

        public Builder longPressListener(LongPressListener listener) {
            this.checkNotDisposed();
            this.mLongPressListener = listener;
            return this;
        }

        public Builder doubleTapListener(DoubleTapListener listener) {
            this.checkNotDisposed();
            this.mdDoubleTapListener = listener;
            return this;
        }

        public void register() {
            this.checkNotDisposed();
            if (this.mConfig == null) {
                this.mConfig = mDefaultConfig;
            }
            if (this.mTargetContainer == null) {
                throw new IllegalArgumentException("Target container must not be null");
            }
            if (this.mTargetView == null) {
                throw new IllegalArgumentException("Target view must not be null");
            }
            this.mTargetView.setOnTouchListener((View.OnTouchListener)new ZoomableTouchListener(this.mTargetContainer, this.mTargetView, this.mConfig, this.mZoomInterpolator, this.mZoomListener, this.mTapListener, this.mLongPressListener, this.mdDoubleTapListener));
            this.mDisposed = true;
        }

        private void checkNotDisposed() {
            if (this.mDisposed) {
                throw new IllegalStateException("Builder already disposed");
            }
        }
    }
}

