/*
 * Decompiled with CFR 0.152.
 */
package com.ablanco.zoomy;

import android.animation.TimeInterpolator;
import android.graphics.Color;
import android.graphics.Point;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import com.ablanco.zoomy.DoubleTapListener;
import com.ablanco.zoomy.LongPressListener;
import com.ablanco.zoomy.MotionUtils;
import com.ablanco.zoomy.TapListener;
import com.ablanco.zoomy.TargetContainer;
import com.ablanco.zoomy.ViewUtils;
import com.ablanco.zoomy.ZoomListener;
import com.ablanco.zoomy.ZoomyConfig;

class ZoomableTouchListener
implements View.OnTouchListener,
ScaleGestureDetector.OnScaleGestureListener {
    private static final int STATE_IDLE = 0;
    private static final int STATE_POINTER_DOWN = 1;
    private static final int STATE_ZOOMING = 2;
    private static final float MIN_SCALE_FACTOR = 1.0f;
    private static final float MAX_SCALE_FACTOR = 5.0f;
    private final TapListener mTapListener;
    private final LongPressListener mLongPressListener;
    private final DoubleTapListener mDoubleTapListener;
    private int mState = 0;
    private TargetContainer mTargetContainer;
    private View mTarget;
    private ImageView mZoomableView;
    private View mShadow;
    private ScaleGestureDetector mScaleGestureDetector;
    private GestureDetector mGestureDetector;
    private GestureDetector.SimpleOnGestureListener mGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (ZoomableTouchListener.this.mTapListener != null) {
                ZoomableTouchListener.this.mTapListener.onTap(ZoomableTouchListener.this.mTarget);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            if (ZoomableTouchListener.this.mLongPressListener != null) {
                ZoomableTouchListener.this.mLongPressListener.onLongPress(ZoomableTouchListener.this.mTarget);
            }
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (ZoomableTouchListener.this.mDoubleTapListener != null) {
                ZoomableTouchListener.this.mDoubleTapListener.onDoubleTap(ZoomableTouchListener.this.mTarget);
            }
            return true;
        }
    };
    private float mScaleFactor = 1.0f;
    private PointF mCurrentMovementMidPoint = new PointF();
    private PointF mInitialPinchMidPoint = new PointF();
    private Point mTargetViewCords = new Point();
    private boolean mAnimatingZoomEnding = false;
    private Interpolator mEndZoomingInterpolator;
    private ZoomyConfig mConfig;
    private ZoomListener mZoomListener;
    private Runnable mEndingZoomAction = new Runnable(){

        @Override
        public void run() {
            ZoomableTouchListener.this.removeFromDecorView(ZoomableTouchListener.this.mShadow);
            ZoomableTouchListener.this.removeFromDecorView((View)ZoomableTouchListener.this.mZoomableView);
            ZoomableTouchListener.this.mTarget.setVisibility(0);
            ZoomableTouchListener.this.mZoomableView = null;
            ZoomableTouchListener.this.mCurrentMovementMidPoint = new PointF();
            ZoomableTouchListener.this.mInitialPinchMidPoint = new PointF();
            ZoomableTouchListener.this.mAnimatingZoomEnding = false;
            ZoomableTouchListener.this.mState = 0;
            if (ZoomableTouchListener.this.mZoomListener != null) {
                ZoomableTouchListener.this.mZoomListener.onViewEndedZooming(ZoomableTouchListener.this.mTarget);
            }
            if (ZoomableTouchListener.this.mConfig.isImmersiveModeEnabled()) {
                ZoomableTouchListener.this.showSystemUI();
            }
        }
    };

    ZoomableTouchListener(TargetContainer targetContainer, View view, ZoomyConfig config, Interpolator interpolator, ZoomListener zoomListener, TapListener tapListener, LongPressListener longPressListener, DoubleTapListener doubleTapListener) {
        this.mTargetContainer = targetContainer;
        this.mTarget = view;
        this.mConfig = config;
        this.mEndZoomingInterpolator = interpolator != null ? interpolator : new AccelerateDecelerateInterpolator();
        this.mScaleGestureDetector = new ScaleGestureDetector(view.getContext(), (ScaleGestureDetector.OnScaleGestureListener)this);
        this.mGestureDetector = new GestureDetector(view.getContext(), (GestureDetector.OnGestureListener)this.mGestureListener);
        this.mZoomListener = zoomListener;
        this.mTapListener = tapListener;
        this.mLongPressListener = longPressListener;
        this.mDoubleTapListener = doubleTapListener;
    }

    public boolean onTouch(View v, MotionEvent ev) {
        if (this.mAnimatingZoomEnding || ev.getPointerCount() > 2) {
            return true;
        }
        this.mScaleGestureDetector.onTouchEvent(ev);
        this.mGestureDetector.onTouchEvent(ev);
        int action = ev.getAction() & 0xFF;
        block0 : switch (action) {
            case 0: 
            case 5: {
                switch (this.mState) {
                    case 0: {
                        this.mState = 1;
                        break;
                    }
                    case 1: {
                        this.mState = 2;
                        MotionUtils.midPointOfEvent(this.mInitialPinchMidPoint, ev);
                        this.startZoomingView(this.mTarget);
                    }
                }
                break;
            }
            case 2: {
                if (this.mState != 2) break;
                MotionUtils.midPointOfEvent(this.mCurrentMovementMidPoint, ev);
                this.mCurrentMovementMidPoint.x -= this.mInitialPinchMidPoint.x;
                this.mCurrentMovementMidPoint.y -= this.mInitialPinchMidPoint.y;
                this.mCurrentMovementMidPoint.x += (float)this.mTargetViewCords.x;
                this.mCurrentMovementMidPoint.y += (float)this.mTargetViewCords.y;
                float x = this.mCurrentMovementMidPoint.x;
                float y = this.mCurrentMovementMidPoint.y;
                this.mZoomableView.setX(x);
                this.mZoomableView.setY(y);
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                switch (this.mState) {
                    case 2: {
                        this.endZoomingView();
                        break block0;
                    }
                    case 1: {
                        this.mState = 0;
                    }
                }
            }
        }
        return true;
    }

    private void endZoomingView() {
        if (this.mConfig.isZoomAnimationEnabled()) {
            this.mAnimatingZoomEnding = true;
            this.mZoomableView.animate().x((float)this.mTargetViewCords.x).y((float)this.mTargetViewCords.y).scaleX(1.0f).scaleY(1.0f).setInterpolator((TimeInterpolator)this.mEndZoomingInterpolator).withEndAction(this.mEndingZoomAction).start();
        } else {
            this.mEndingZoomAction.run();
        }
    }

    private void startZoomingView(View view) {
        this.mZoomableView = new ImageView(this.mTarget.getContext());
        this.mZoomableView.setLayoutParams(new ViewGroup.LayoutParams(this.mTarget.getWidth(), this.mTarget.getHeight()));
        this.mZoomableView.setImageBitmap(ViewUtils.getBitmapFromView(view));
        this.mTargetViewCords = ViewUtils.getViewAbsoluteCords(view);
        this.mZoomableView.setX((float)this.mTargetViewCords.x);
        this.mZoomableView.setY((float)this.mTargetViewCords.y);
        if (this.mShadow == null) {
            this.mShadow = new View(this.mTarget.getContext());
        }
        this.mShadow.setBackgroundResource(0);
        this.addToDecorView(this.mShadow);
        this.addToDecorView((View)this.mZoomableView);
        this.disableParentTouch(this.mTarget.getParent());
        this.mTarget.setVisibility(4);
        if (this.mConfig.isImmersiveModeEnabled()) {
            this.hideSystemUI();
        }
        if (this.mZoomListener != null) {
            this.mZoomListener.onViewStartedZooming(this.mTarget);
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        if (this.mZoomableView == null) {
            return false;
        }
        this.mScaleFactor *= detector.getScaleFactor();
        this.mScaleFactor = Math.max(1.0f, Math.min(this.mScaleFactor, 5.0f));
        this.mZoomableView.setScaleX(this.mScaleFactor);
        this.mZoomableView.setScaleY(this.mScaleFactor);
        this.obscureDecorView(this.mScaleFactor);
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        return this.mZoomableView != null;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        this.mScaleFactor = 1.0f;
    }

    private void addToDecorView(View v) {
        this.mTargetContainer.getDecorView().addView(v);
    }

    private void removeFromDecorView(View v) {
        this.mTargetContainer.getDecorView().removeView(v);
    }

    private void obscureDecorView(float factor) {
        float normalizedValue = (factor - 1.0f) / 4.0f;
        normalizedValue = Math.min(0.75f, normalizedValue * 2.0f);
        int obscure = Color.argb((int)((int)(normalizedValue * 255.0f)), (int)0, (int)0, (int)0);
        this.mShadow.setBackgroundColor(obscure);
    }

    private void hideSystemUI() {
        this.mTargetContainer.getDecorView().setSystemUiVisibility(262);
    }

    private void showSystemUI() {
        this.mTargetContainer.getDecorView().setSystemUiVisibility(0);
    }

    private void disableParentTouch(ViewParent view) {
        view.requestDisallowInterceptTouchEvent(true);
        if (view.getParent() != null) {
            this.disableParentTouch(view.getParent());
        }
    }
}

