/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.ContentTypes;
import groovyx.net.http.EmbeddedEncoder;
import groovyx.net.http.MultipartContent;
import groovyx.net.http.ToServer;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;

public class OkHttpEncoders {
    public static void multipart(ChainedHttpConfig config, ToServer ts) {
        try {
            ChainedHttpConfig.ChainedRequest request = config.getChainedRequest();
            Object body = request.actualBody();
            if (!(body instanceof MultipartContent)) {
                throw new IllegalArgumentException("Multipart body content must be MultipartContent.");
            }
            String contentType = request.actualContentType();
            if (!contentType.equals(ContentTypes.MULTIPART_FORMDATA.getAt(0)) && !contentType.equals(ContentTypes.MULTIPART_MIXED.getAt(0))) {
                throw new IllegalArgumentException("Multipart body content must be multipart/form-data.");
            }
            MultipartBody.Builder builder = new MultipartBody.Builder();
            for (MultipartContent.MultipartPart mpe : ((MultipartContent)body).parts()) {
                if (mpe.getFileName() == null) {
                    builder.addFormDataPart(mpe.getFieldName(), (String)mpe.getContent());
                    continue;
                }
                builder.addFormDataPart(mpe.getFieldName(), mpe.getFileName(), RequestBody.create((MediaType)MediaType.parse((String)mpe.getContentType()), (byte[])EmbeddedEncoder.encode((ChainedHttpConfig)config, (String)mpe.getContentType(), (Object)mpe.getContent())));
            }
            Buffer buffer = new Buffer();
            MultipartBody multipartBody = builder.build();
            multipartBody.writeTo((BufferedSink)buffer);
            request.setContentType("multipart/form-data; boundary=" + multipartBody.boundary());
            ts.toServer(buffer.inputStream());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

