/**
 * <h1>cdk-comprehend-s3olap</h1>
 * <p>
 * <a href="https://opensource.org/licenses/Apache-2.0"><img alt="License" src="https://img.shields.io/badge/License-Apache%202.0-green"></a> <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/actions/workflows/release.yml"><img alt="Release" src="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/actions/workflows/release.yml/badge.svg"></a> <a href="https://img.shields.io/npm/dt/cdk-comprehend-s3olap?label=npm%20downloads&amp;style=plastic"><img alt="npm downloads" src="https://img.shields.io/npm/dt/cdk-comprehend-s3olap?label=npm%20downloads&amp;style=plastic"></a> <a href="https://img.shields.io/pypi/dm/cdk-comprehend-s3olap?label=pypi%20downloads&amp;style=plastic"><img alt="pypi downloads" src="https://img.shields.io/pypi/dm/cdk-comprehend-s3olap?label=pypi%20downloads&amp;style=plastic"></a> <a href="https://img.shields.io/nuget/dt/Comprehend.S3olap?label=NuGet%20downloads&amp;style=plastic"><img alt="NuGet downloads" src="https://img.shields.io/nuget/dt/Comprehend.S3olap?label=NuGet%20downloads&amp;style=plastic"></a> <a href="https://img.shields.io/github/languages/count/HsiehShuJeng/cdk-comprehend-s3olap?label=repo%20languages&amp;style=plastic"><img alt="repo languages" src="https://img.shields.io/github/languages/count/HsiehShuJeng/cdk-comprehend-s3olap?label=repo%20languages&amp;style=plastic"></a>
 * <p>
 * | npm (JS/TS) | PyPI (Python) | Maven (Java) | Go | NuGet |
 * | --- | --- | --- | --- | --- |
 * | <a href="https://www.npmjs.com/package/cdk-comprehend-s3olap">Link</a> | <a href="https://pypi.org/project/cdk_comprehend_s3olap/">Link</a> | <a href="https://search.maven.org/artifact/io.github.hsiehshujeng/cdk-comprehend-s3olap">Link</a> | <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap-go">Link</a> | <a href="https://www.nuget.org/packages/Comprehend.S3olap/">Link</a> |
 * <p>
 * This construct creates the foundation for developers to explore the combination of Amazon S3 Object Lambda and Amazon Comprehend for PII scenarios and it is designed with flexibility, i.e, the developers could tweak arguments via CDK to see how AWS services work and behave.
 * <p>
 * <h1>Table of Contents</h1>
 * <p>
 * <ul>
 * <li><a href="#serverless-architecture">Serverless Architecture</a>
 * <p>
 * <ul>
 * <li><a href="#access-control">Access Control</a></li>
 * <li><a href="#rerfaction">Redaction</a></li>
 * </ul></li>
 * <li><a href="#introduction">Introduction</a></li>
 * <li><a href="#example">Example</a>
 * <p>
 * <ul>
 * <li><a href="#typescript">Typescript</a></li>
 * <li><a href="#python">Python</a></li>
 * <li><a href="#java">Java</a></li>
 * <li><a href="#c">C#</a></li>
 * </ul></li>
 * <li><a href="#some-notes">Some Notes</a></li>
 * </ul>
 * <p>
 * <h1>Serverless Architecture</h1>
 * <p>
 * <h2>Access Control</h2>
 * <p>
 * <strong>Data Flow</strong>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/1-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <strong>Arhictecture</strong>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/2-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <p>
 * <h2>Redaction</h2>
 * <p>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/3-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/4-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <p>
 * <h1>Introduction</h1>
 * <p>
 * The architecture was introduced by <strong>Ram Ramani</strong> and <strong>Austin Quam</strong> and was posted on the AWS Blog as <a href="https://aws.amazon.com/tw/blogs/machine-learning/protect-pii-using-amazon-s3-object-lambda-to-process-and-modify-data-during-retrieval/"><em>Protect PII using Amazon S3 Object Lambda to process and modify data during retrieval</em></a>.
 * I converted the architecture into a CDK constrcut for 4 programming languages. With this construct, you could manage the properties of IAM roles, the Lambda functions with Amazon Comprehend, and few for the constrcut.
 * Before deploying the construct via the CDK, you could either places the text files, i.e., those for the access control case and redaction case, under a directory with a specific name as the following or just deploying directly yet you need to upload the text files onto the S3 buckets manually yourself. It's all your choie.
 * <p>
 * <blockquote><pre>
 * # For the access control case.
 * $ cd ${ROOT_DIRECTORY_CDK_APPLICATION}
 * $ mkdir -p files/access_control
 * $ curl -o survey-results.txt https://raw.githubusercontent.com/aws-samples/amazon-comprehend-examples/master/s3_object_lambda_pii_protection_blog/access-control/survey-results.txt
 * $ curl -o innocuous.txt https://raw.githubusercontent.com/aws-samples/amazon-comprehend-examples/master/s3_object_lambda_pii_protection_blog/access-control/innocuous.txt
 * # For the redaction case.
 * $ cd ${ROOT_DIRECTORY_CDK_APPLICATION}
 * $ mkdir -p files/redaction
 * $ curl -o transcript.txt https://raw.githubusercontent.com/aws-samples/amazon-comprehend-examples/master/s3_object_lambda_pii_protection_blog/redaction/transcript.txt
 * </pre></blockquote>
 * <p>
 * <h1>Example</h1>
 * <p>
 * <h2>Typescript</h2>
 * <p>
 * You could also refer to <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/tree/main/src/demo/typescript">here</a>.
 * <p>
 * <blockquote><pre>
 * $ cdk --init language typescript
 * $ yarn add cdk-comprehend-s3olap
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * import * as cdk from '&#64;aws-cdk/core';
 * import { ComprehendS3olab } from 'cdk-comprehend-s3olap';
 * 
 * class TypescriptStack extends cdk.Stack {
 *   constructor(scope: cdk.Construct, id: string, props?: cdk.StackProps) {
 *     super(scope, id, props);
 *     const s3olab = new ComprehendS3olab(this, 'PiiDemo', {
 *       adminRedactionLambdaConfig: {
 *         maskCharacter: ' ',
 *         unsupportedFileHandling: 'PASS',
 *       },
 *       billingRedactionLambdaConfig: {
 *         maskMode: 'REPLACE_WITH_PII_ENTITY_TYPE',
 *         piiEntityTypes: 'AGE,DRIVER_ID,IP_ADDRESS,MAC_ADDRESS,PASSPORT_NUMBER,PASSWORD,SSN',
 *       },
 *       cusrtSupportRedactionLambdaConfig: {
 *         maskMode: 'REPLACE_WITH_PII_ENTITY_TYPE',
 *         piiEntityTypes: ' BANK_ACCOUNT_NUMBER,BANK_ROUTING,CREDIT_DEBIT_CVV,CREDIT_DEBIT_EXPIRY,CREDIT_DEBIT_NUMBER,SSN',
 *       },
 *     });
 * 
 *     new cdk.CfnOutput(this, 'OPiiAccessControlLambdaArn', { value: s3olab.piiAccessConrtolLambdaArn });
 *     new cdk.CfnOutput(this, 'OAdminLambdaArn', { value: s3olab.adminLambdaArn });
 *     new cdk.CfnOutput(this, 'OBillingLambdaArn', { value: s3olab.billingLambdaArn });
 *     new cdk.CfnOutput(this, 'OCustomerSupportLambdaArn', { value: s3olab.customerSupportLambdaArn });
 *     new cdk.CfnOutput(this, 'OS3ObjectLambdaGeneralArn', { value: s3olab.s3objectLambdaAccessControlArn });
 *     new cdk.CfnOutput(this, 'OS3ObjectLambdaAdminArn', { value: s3olab.s3objectLambdaAdminArn });
 *     new cdk.CfnOutput(this, 'OS3ObjectLambdaBillingArn', { value: s3olab.s3objectLambdaBillingArn });
 *     new cdk.CfnOutput(this, 'OS3ObjectLambdaCustomerSupportArn', { value: s3olab.customerSupportLambdaArn });
 *   }
 * }
 * 
 * const app = new cdk.App();
 * new TypescriptStack(app, 'TypescriptStack', {
 *   stackName: 'Comprehend-S3olap',
 * });
 * </pre></blockquote>
 * <p>
 * <h2>Python</h2>
 * <p>
 * You could also refer to <a href="https://github.com/HsiehShuJeng/cdk-databrew-cicd/tree/main/src/demo/python">here</a>.
 * <p>
 * <blockquote><pre>
 * # upgrading related Python packages
 * $ python -m ensurepip --upgrade
 * $ python -m pip install --upgrade pip
 * $ python -m pip install --upgrade virtualenv
 * # initialize a CDK Python project
 * $ cdk init --language python
 * # make packages installed locally instead of globally
 * $ source .venv/bin/activate
 * $ # add "cdk-comprehend-s3olap==0.0.4" into `setup.py`
 * $ python -m pip install --upgrade -r requirements.txt
 * </pre></blockquote>
 * <p>
 * The demonstration sample code of Python can be viewed via the Python tab of this package on the <a href="https://constructs.dev/">Constrcut Hub</a>.
 * <p>
 * <h2>Java</h2>
 * <p>
 * You could also refer to <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/tree/main/src/demo/java">here</a>.
 * <p>
 * <blockquote><pre>
 * $ cdk init --language java
 * $ mvn package # If you include the construct, you need to tweak the test case for Java in order to package with success via Maven.
 * ```xml
 * .
 * .
 * &lt;properties&gt;
 *     &lt;project.build.sourceEncoding&gt;UTF-8&lt;/project.build.sourceEncoding&gt;
 *     &lt;cdk.version&gt;1.112.0&lt;/cdk.version&gt;
 *     &lt;constrcut.verion&gt;0.0.4&lt;/constrcut.verion&gt;
 *     &lt;junit.version&gt;5.7.1&lt;/junit.version&gt;
 * &lt;/properties&gt;
 * .
 * .
 * &lt;dependencies&gt;
 *     &lt;!-- AWS Cloud Development Kit --&gt;
 *     &lt;dependency&gt;
 *         &lt;groupId&gt;software.amazon.awscdk&lt;/groupId&gt;
 *         &lt;artifactId&gt;core&lt;/artifactId&gt;
 *         &lt;version&gt;${cdk.version}&lt;/version&gt;
 *     &lt;/dependency&gt;
 *     &lt;dependency&gt;
 *         &lt;groupId&gt;io.github.hsiehshujeng&lt;/groupId&gt;
 *         &lt;artifactId&gt;cdk-comprehend-s3olap&lt;/artifactId&gt;
 *         &lt;version&gt;${constrcut.verion}&lt;/version&gt;
 *     &lt;/dependency&gt;
 *     .
 *     .
 *     .
 * &lt;/dependencies&gt;
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * package com.myorg;
 * 
 * import software.amazon.awscdk.core.CfnOutput;
 * import software.amazon.awscdk.core.CfnOutputProps;
 * import software.amazon.awscdk.core.Construct;
 * import software.amazon.awscdk.core.Stack;
 * import software.amazon.awscdk.core.StackProps;
 * import io.github.hsiehshujeng.cdk.comprehend.s3olap.RedactionLambdaProps;
 * import io.github.hsiehshujeng.cdk.comprehend.s3olap.ComprehendS3olab;
 * import io.github.hsiehshujeng.cdk.comprehend.s3olap.ComprehendS3olabProps;
 * 
 * public class JavaStack extends Stack {
 *     public JavaStack(final Construct scope, final String id) {
 *         this(scope, id, null);
 *     }
 * 
 *     public JavaStack(final Construct scope, final String id, final StackProps props) {
 *         super(scope, id, props);
 * 
 *         ComprehendS3olab s3olab = new ComprehendS3olab(this, "PiiDemo", ComprehendS3olabProps.builder()
 *             .adminRedactionLambdaConfig(
 *                 RedactionLambdaProps.builder()
 *                     .maskCharacter(" ")
 *                     .unsupportedFileHandling("PASS").build())
 *             .billingRedactionLambdaConfig(
 *                 RedactionLambdaProps.builder()
 *                     .maskMode("REPLACE_WITH_PII_ENTITY_TYPE")
 *                     .piiEntityTypes("AGE,DRIVER_ID,IP_ADDRESS,MAC_ADDRESS,PASSPORT_NUMBER,PASSWORD,SSN")
 *                     .build())
 *             .cusrtSupportRedactionLambdaConfig(
 *                 RedactionLambdaProps.builder()
 *                 .maskMode("REPLACE_WITH_PII_ENTITY_TYPE")
 *                 .piiEntityTypes("BANK_ACCOUNT_NUMBER,BANK_ROUTING,CREDIT_DEBIT_CVV,CREDIT_DEBIT_EXPIRY,CREDIT_DEBIT_NUMBER,SSN")
 *                 .build())
 *             .exampleFileDir("/opt/learning/cdk-comprehend-s3olap/src/demo/java")
 *             .build()
 *             );
 * 
 *           new CfnOutput(this, "OPiiAccessControlLambdaArn", CfnOutputProps.builder().value(s3olab.getPiiAccessConrtolLambdaArn()).build());
 *           new CfnOutput(this, "OAdminLambdaArn", CfnOutputProps.builder().value(s3olab.getAdminLambdaArn()).build());
 *           new CfnOutput(this, "OBillingLambdaArn", CfnOutputProps.builder().value(s3olab.getBillingLambdaArn()).build());
 *           new CfnOutput(this, "OCustomerSupportLambdaArn", CfnOutputProps.builder().value(s3olab.getCustomerSupportLambdaArn()).build());
 *           new CfnOutput(this, "OS3ObjectLambdaGeneralArn", CfnOutputProps.builder().value(s3olab.getS3objectLambdaAccessControlArn()).build());
 *           new CfnOutput(this, "OS3ObjectLambdaAdminArn", CfnOutputProps.builder().value(s3olab.getS3objectLambdaAdminArn()).build());
 *           new CfnOutput(this, "OS3ObjectLambdaBillingArn", CfnOutputProps.builder().value(s3olab.getS3objectLambdaBillingArn()).build());
 *           new CfnOutput(this, "OS3ObjectLambdaCustomerSupportArn", CfnOutputProps.builder().value(s3olab.getCustomerSupportLambdaArn()).build());
 *     }
 * }
 * </pre></blockquote>
 * <p>
 * <h2>C#</h2>
 * <p>
 * You could also refer to <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/tree/main/src/demo/csharp">here</a>.
 * <p>
 * <blockquote><pre>
 * $ cdk init --language csharp
 * $ dotnet add src/Csharp package Comprehend.S3olap --version 0.0.8
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * using Amazon.CDK;
 * using ScottHsieh.Cdk;
 * 
 * namespace Csharp
 * {
 *     public class CsharpStack : Stack
 *     {
 *         internal CsharpStack(Construct scope, string id, IStackProps props = null) : base(scope, id, props)
 *         {
 *             var S3olab = new ComprehendS3olab(this, "PiiDemo", new ComprehendS3olabProps
 *             {
 *                 AdminRedactionLambdaConfig = new RedactionLambdaProps
 *                 {
 *                     MaskCharacter = " ",
 *                     UnsupportedFileHandling = "PASS"
 *                 },
 *                 BillingRedactionLambdaConfig = new RedactionLambdaProps
 *                 {
 *                     MaskMode = "REPLACE_WITH_PII_ENTITY_TYPE",
 *                     PiiEntityTypes = "AGE,DRIVER_ID,IP_ADDRESS,MAC_ADDRESS,PASSPORT_NUMBER,PASSWORD,SSN"
 *                 },
 *                 CusrtSupportRedactionLambdaConfig = new RedactionLambdaProps
 *                 {
 *                     MaskMode = "REPLACE_WITH_PII_ENTITY_TYPE",
 *                     PiiEntityTypes = "BANK_ACCOUNT_NUMBER,BANK_ROUTING,CREDIT_DEBIT_CVV,CREDIT_DEBIT_EXPIRY,CREDIT_DEBIT_NUMBER,SSN"
 *                 },
 *                 ExampleFileDir = "/opt/learning/cdk-comprehend-s3olap/src/demo/csharp"
 *             });
 * 
 *             new CfnOutput(this, "OPiiAccessControlLambdaArn", new CfnOutputProps { Value = S3olab.PiiAccessConrtolLambdaArn });
 *             new CfnOutput(this, "OAdminLambdaArn", new CfnOutputProps { Value = S3olab.AdminLambdaArn });
 *             new CfnOutput(this, "OBillingLambdaArn", new CfnOutputProps { Value = S3olab.BillingLambdaArn });
 *             new CfnOutput(this, "OCustomerSupportLambdaArn", new CfnOutputProps { Value = S3olab.CustomerSupportLambdaArn });
 *             new CfnOutput(this, "OS3ObjectLambdaGeneralArn", new CfnOutputProps { Value = S3olab.S3objectLambdaAccessControlArn });
 *             new CfnOutput(this, "OS3ObjectLambdaAdminArn", new CfnOutputProps { Value = S3olab.S3objectLambdaAdminArn });
 *             new CfnOutput(this, "OS3ObjectLambdaBillingArn", new CfnOutputProps { Value = S3olab.S3objectLambdaBillingArn });
 *             new CfnOutput(this, "OS3ObjectLambdaCustomerSupportArn", new CfnOutputProps { Value = S3olab.CustomerSupportLambdaArn });
 *         }
 *     }
 * }
 * </pre></blockquote>
 * <p>
 * <h1>Some Notes</h1>
 * <p>
 * <ol>
 * <li>You should see similar items as the following diagram displays after deploying the constrcut.
 * <img alt="image" src="https://raw.githubusercontent.com/HsiehShuJeng/cdk-comprehend-s3olap/main/images/s3olap_console.png"></li>
 * <li>After creating the foundation with success, you could switch roles that the consrtcut creates for you and see how <strong>Amazon S3 Object Lambda</strong> works. For what switching roles is, please refer to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-console.html">here</a> for the detail.
 * <img alt="image" src="https://raw.githubusercontent.com/HsiehShuJeng/cdk-comprehend-s3olap/main/images/switch_roles.png"></li>
 * <li>You explore <strong>Amazon S3 Object Lambda</strong> through the Object Lambda access points on the AWS Console and open or download the text files via one of the IAM roles.</li>
 * <li>Lambda code that incorporates with <strong>Amazon Comprehend</strong> could be see <a href="https://github.com/aws-samples/amazon-comprehend-examples/tree/master/s3_object_lambda_pii_protection_blog">here</a>.</li>
 * </ol>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package io.github.hsiehshujeng.cdk.comprehend.s3olap;
