/**
 * <h1>cdk-comprehend-s3olap</h1>
 * <p>
 * This construct creates the foundation for developers to explore the combination of Amazon S3 Object Lambda and Amazon Comprehend for PII scenarios and it is designed with flexibility, i.e, the developers could tweak arguments via CDK to see how AWS services work and behave.
 * <p>
 * <a href="https://opensource.org/licenses/Apache-2.0"><img alt="License" src="https://img.shields.io/badge/License-Apache%202.0-green"></a>
 * <a href="https://github.com/aws/aws-cdk"><img alt="Current cdk version" src="https://img.shields.io/github/package-json/dependency-version/HsiehShuJeng/cdk-comprehend-s3olap/&#64;aws-cdk/core"></a>
 * <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/actions/workflows/build.yml"><img alt="Build" src="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/actions/workflows/build.yml/badge.svg"></a> <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/actions/workflows/release.yml"><img alt="Release" src="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/workflows/Release/badge.svg"></a>
 * <a href="https://pypi.org"><img alt="Python" src="https://img.shields.io/pypi/pyversions/cdk-comprehend-s3olap"></a> <a href="https://pypi.org/project/cdk-comprehend-s3olap/"><img alt="pip" src="https://img.shields.io/badge/pip%20install-cdk--comprehend--s3olap-blue"></a>
 * <a href="https://www.npmjs.com/package/cdk-comprehend-s3olap"><img alt="npm version" src="https://img.shields.io/npm/v/cdk-comprehend-s3olap"></a> <a href="https://pypi.org/project/cdk-comprehend-s3olap/"><img alt="pypi version" src="https://img.shields.io/pypi/v/cdk-comprehend-s3olap"></a> <a href="https://search.maven.org/search?q=a:cdk-comprehend-s3olap"><img alt="Maven" src="https://img.shields.io/maven-central/v/io.github.hsiehshujeng/cdk-comprehend-s3olap"></a> <a href="https://www.nuget.org/packages/Comprehend.S3olap/"><img alt="nuget" src="https://img.shields.io/nuget/v/Comprehend.S3olap"></a>
 * <p>
 * <h1>Table of Contents</h1>
 * <p>
 * <ul>
 * <li><a href="#serverless-architecture">Serverless Architecture</a>
 * <p>
 * <ul>
 * <li><a href="#access-control">Access Control</a></li>
 * <li><a href="#rerfaction">Redaction</a></li>
 * </ul></li>
 * <li><a href="#introduction">Introduction</a></li>
 * <li><a href="#example">Example</a>
 * <p>
 * <ul>
 * <li><a href="#typescript">Typescript</a></li>
 * <li><a href="#python">Python</a></li>
 * <li><a href="#java">Java</a></li>
 * <li><a href="#c">C#</a></li>
 * </ul></li>
 * <li><a href="#some-notes">Some Notes</a></li>
 * </ul>
 * <p>
 * <h1>Serverless Architecture</h1>
 * <p>
 * <h2>Access Control</h2>
 * <p>
 * <strong>Data Flow</strong>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/1-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <strong>Arhictecture</strong>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/2-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <p>
 * <h2>Redaction</h2>
 * <p>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/3-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <img alt="image" src="https://d2908q01vomqb2.cloudfront.net/f1f836cb4ea6efb2a0b1b99f41ad8b103eff4b59/2021/05/07/4-2891.jpg">
 * <em>Ram R. and Austin Q., 2021</em>
 * <p>
 * <h1>Introduction</h1>
 * <p>
 * The architecture was introduced by <strong>Ram Ramani</strong> and <strong>Austin Quam</strong> and was posted on the AWS Blog as <a href="https://aws.amazon.com/tw/blogs/machine-learning/protect-pii-using-amazon-s3-object-lambda-to-process-and-modify-data-during-retrieval/"><em>Protect PII using Amazon S3 Object Lambda to process and modify data during retrieval</em></a>.
 * I converted the architecture into a CDK constrcut for 4 programming languages. With this construct, you could manage the properties of IAM roles, the Lambda functions with Amazon Comprehend, and few for the constrcut.
 * Before deploying the construct via the CDK, you could either places the text files, i.e., those for the access control case and redaction case, under a directory with a specific name as the following or just deploying directly yet you need to upload the text files onto the S3 buckets manually yourself. It's all your choie.
 * <p>
 * <blockquote><pre>
 * # For the access control case.
 * $ cd ${ROOT_DIRECTORY_CDK_APPLICATION}
 * $ mkdir -p files/access_control
 * $ curl -o survey-results.txt https://raw.githubusercontent.com/aws-samples/amazon-comprehend-examples/master/s3_object_lambda_pii_protection_blog/access-control/survey-results.txt
 * $ curl -o innocuous.txt https://raw.githubusercontent.com/aws-samples/amazon-comprehend-examples/master/s3_object_lambda_pii_protection_blog/access-control/innocuous.txt
 * # For the redaction case.
 * $ cd ${ROOT_DIRECTORY_CDK_APPLICATION}
 * $ mkdir -p files/redaction
 * $ curl -o transcript.txt https://raw.githubusercontent.com/aws-samples/amazon-comprehend-examples/master/s3_object_lambda_pii_protection_blog/redaction/transcript.txt
 * </pre></blockquote>
 * <p>
 * <h1>Example</h1>
 * <p>
 * <h2>Typescript</h2>
 * <p>
 * You could also refer to <a href="https://github.com/HsiehShuJeng/cdk-comprehend-s3olap/tree/main/src/demo/typescript">here</a>.
 * <p>
 * <blockquote><pre>
 * $ cdk --init language typescript
 * $ yarn add cdk-comprehend-s3olap
 * </pre></blockquote>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.core.*;
 * import cdk.comprehend.s3olap.ComprehendS3olab;
 * 
 * public class TypescriptStack extends Stack {
 *     public TypescriptStack(Construct scope, String id) {
 *         this(scope, id, null);
 *     }
 * 
 *     public TypescriptStack(Construct scope, String id, StackProps props) {
 *         super(scope, id, props);
 *         Object s3olab = ComprehendS3olab.Builder.create(this, "PiiDemo")
 *                 .adminRedactionLambdaConfig(Map.of(
 *                         "maskCharacter", " ",
 *                         "unsupportedFileHandling", "PASS"))
 *                 .billingRedactionLambdaConfig(Map.of(
 *                         "maskMode", "REPLACE_WITH_PII_ENTITY_TYPE",
 *                         "piiEntityTypes", "AGE,DRIVER_ID,IP_ADDRESS,MAC_ADDRESS,PASSPORT_NUMBER,PASSWORD,SSN"))
 *                 .cusrtSupportRedactionLambdaConfig(Map.of(
 *                         "maskMode", "REPLACE_WITH_PII_ENTITY_TYPE",
 *                         "piiEntityTypes", " BANK_ACCOUNT_NUMBER,BANK_ROUTING,CREDIT_DEBIT_CVV,CREDIT_DEBIT_EXPIRY,CREDIT_DEBIT_NUMBER,SSN"))
 *                 .build();
 * 
 *         new CfnOutput(this, "OPiiAccessControlLambdaArn", new CfnOutputProps().value(s3olab.getPiiAccessConrtolLambdaArn()));
 *         new CfnOutput(this, "OAdminLambdaArn", new CfnOutputProps().value(s3olab.getAdminLambdaArn()));
 *         new CfnOutput(this, "OBillingLambdaArn", new CfnOutputProps().value(s3olab.getBillingLambdaArn()));
 *         new CfnOutput(this, "OCustomerSupportLambdaArn", new CfnOutputProps().value(s3olab.getCustomerSupportLambdaArn()));
 *         new CfnOutput(this, "OS3ObjectLambdaGeneralArn", new CfnOutputProps().value(s3olab.getS3objectLambdaAccessControlArn()));
 *         new CfnOutput(this, "OS3ObjectLambdaAdminArn", new CfnOutputProps().value(s3olab.getS3objectLambdaAdminArn()));
 *         new CfnOutput(this, "OS3ObjectLambdaBillingArn", new CfnOutputProps().value(s3olab.getS3objectLambdaBillingArn()));
 *         new CfnOutput(this, "OS3ObjectLambdaCustomerSupportArn", new CfnOutputProps().value(s3olab.getCustomerSupportLambdaArn()));
 *     }
 * }
 * 
 * App app = new App();
 * new TypescriptStack(app, "TypescriptStack", new StackProps()
 *         .stackName("Comprehend-S3olap"));
 * </pre></blockquote>
 * <p>
 * <h2>Python</h2>
 * <p>
 * TBD
 * <p>
 * <h2>Java</h2>
 * <p>
 * TBD
 * <p>
 * <h2>C#</h2>
 * <p>
 * TBD
 * <p>
 * <h1>Some Notes</h1>
 * <p>
 * <ol>
 * <li>You should see similar items as the following diagram displays after deploying the constrcut.
 * <img alt="image" src="https://raw.githubusercontent.com/HsiehShuJeng/cdk-comprehend-s3olap/main/images/s3olap_console.png"></li>
 * <li>After creating the foundation with success, you could switch roles that the consrtcut creates for you and see how Amazon S3 Object Lambda works.
 * <img alt="image" src="https://raw.githubusercontent.com/HsiehShuJeng/cdk-comprehend-s3olap/main/images/switch_roles.png"></li>
 * <li>You explore Amazon S3 Object Lambda through the Object Lambda access points and open or download the text files.</li>
 * <li>Lambda code that incorporates with Amazon Comprehend could be see <a href="https://github.com/aws-samples/amazon-comprehend-examples/tree/master/s3_object_lambda_pii_protection_blog">here</a>.</li>
 * </ol>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package io.github.hsiehshujeng.cdk.comprehend.s3olap;
