/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.util;

import android.opengl.GLES20;
import android.util.Log;

class GLCheckUtil {
    private static final String TAG = "GLCheckUtil";

    GLCheckUtil() {
    }

    private void checkGlState(String stage) {
        int error = GLES20.glGetError();
        if (error != 0) {
            Log.e((String)TAG, (String)("OpenGL error at " + stage + ": " + this.getGLErrorString(error)));
        }
    }

    private String getGLErrorString(int error) {
        switch (error) {
            case 1280: {
                return "GL_INVALID_ENUM";
            }
            case 1281: {
                return "GL_INVALID_VALUE";
            }
            case 1282: {
                return "GL_INVALID_OPERATION";
            }
            case 1285: {
                return "GL_OUT_OF_MEMORY";
            }
        }
        return "Unknown error: " + error;
    }

    private void checkFramebufferStatus() {
        int status = GLES20.glCheckFramebufferStatus((int)36160);
        if (status != 36053) {
            throw new IllegalStateException("Framebuffer not complete: " + (switch (status) {
                case 36054 -> "Incomplete attachment";
                case 36057 -> "Incomplete dimensions";
                case 36055 -> "Missing attachment";
                case 36061 -> "Unsupported";
                default -> "Unknown: " + status;
            }));
        }
    }
}

