/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.graphics.Bitmap;
import android.util.Log;
import android.view.View;
import com.hoko.blur.api.IBlurProcessor;
import com.hoko.blur.opengl.EglBuffer;
import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.processor.HokoBlurBuild;
import com.hoko.blur.task.AsyncBlurTask;
import com.hoko.blur.task.BitmapAsyncBlurTask;
import com.hoko.blur.task.BlurTaskManager;
import com.hoko.blur.task.ViewAsyncBlurTask;
import com.hoko.blur.util.Preconditions;
import java.util.concurrent.Future;

class OpenGLBlurProcessor
extends BlurProcessor {
    private static final String TAG = OpenGLBlurProcessor.class.getSimpleName();
    private final EglBuffer mEglBuffer = new EglBuffer();

    OpenGLBlurProcessor(HokoBlurBuild builder) {
        super(builder);
    }

    @Override
    protected Bitmap doInnerBlur(Bitmap scaledInBitmap, boolean concurrent) {
        Preconditions.checkNotNull(scaledInBitmap, "scaledInBitmap == null");
        Preconditions.checkArgument(!scaledInBitmap.isRecycled(), "You must input an unrecycled bitmap !");
        try {
            return this.mEglBuffer.getBlurBitmap(scaledInBitmap, this.mRadius, this.mMode);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Blur the bitmap error", (Throwable)e);
            return scaledInBitmap;
        }
    }

    @Override
    public Future<?> asyncBlur(Bitmap bitmap, AsyncBlurTask.Callback callback) {
        return BlurTaskManager.getInstance().enqueue(new BitmapAsyncBlurTask((IBlurProcessor)this, bitmap, callback, this.mDispatcher));
    }

    @Override
    public Future<?> asyncBlur(View view, AsyncBlurTask.Callback callback) {
        return BlurTaskManager.getInstance().enqueue(new ViewAsyncBlurTask((IBlurProcessor)this, view, callback, this.mDispatcher));
    }
}

