/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.hoko.blur.api.IBlurBuild;
import com.hoko.blur.api.IBlurProcessor;
import com.hoko.blur.api.IBlurResultDispatcher;
import com.hoko.blur.processor.BlurProcessorFactory;
import com.hoko.blur.task.AndroidBlurResultDispatcher;
import com.hoko.blur.task.AsyncBlurTask;
import java.util.concurrent.Future;

public final class HokoBlurBuild
implements IBlurBuild {
    int mMode = 2;
    int mScheme = 1003;
    int mRadius = 5;
    float mSampleFactor = 5.0f;
    boolean mIsForceCopy = false;
    int mTranslateX = 0;
    int mTranslateY = 0;
    IBlurResultDispatcher mDispatcher = AndroidBlurResultDispatcher.MAIN_THREAD_DISPATCHER;
    Context mCtx;

    public HokoBlurBuild(Context context) {
        this.mCtx = context;
    }

    @Override
    public IBlurBuild context(Context context) {
        this.mCtx = context;
        return this;
    }

    @Override
    public IBlurBuild mode(int mode) {
        this.mMode = mode;
        return this;
    }

    @Override
    public IBlurBuild scheme(int scheme) {
        this.mScheme = scheme;
        return this;
    }

    @Override
    public IBlurBuild radius(int radius) {
        this.mRadius = radius;
        return this;
    }

    @Override
    public IBlurBuild sampleFactor(float sampleFactor) {
        if (sampleFactor < 1.0f) {
            sampleFactor = 1.0f;
        }
        this.mSampleFactor = sampleFactor;
        return this;
    }

    @Override
    public IBlurBuild forceCopy(boolean isForceCopy) {
        this.mIsForceCopy = isForceCopy;
        return this;
    }

    @Override
    public IBlurBuild translateX(int translateX) {
        this.mTranslateX = translateX;
        return this;
    }

    @Override
    public IBlurBuild translateY(int translateY) {
        this.mTranslateY = translateY;
        return this;
    }

    @Override
    public IBlurBuild dispatcher(IBlurResultDispatcher dispatcher) {
        this.mDispatcher = dispatcher;
        return this;
    }

    @Override
    public IBlurProcessor processor() {
        return BlurProcessorFactory.getBlurProcessor(this.mScheme, this);
    }

    @Override
    public Bitmap blur(Bitmap bitmap) {
        return this.processor().blur(bitmap);
    }

    @Override
    public Bitmap blur(View view) {
        return this.processor().blur(view);
    }

    @Override
    public Future<?> asyncBlur(Bitmap bitmap, AsyncBlurTask.Callback callback) {
        return this.processor().asyncBlur(bitmap, callback);
    }

    @Override
    public Future<?> asyncBlur(View view, AsyncBlurTask.Callback callback) {
        return this.processor().asyncBlur(view, callback);
    }
}

