/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import com.hoko.blur.opengl.Texture;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class TextureCache {
    private static final String TAG = "TextureCache";
    private static final int MAX_POOL_SIZE = 20;
    private static final TextureCache INSTANCE = new TextureCache();
    private final Map<String, TexturePool> sizePools = new ConcurrentHashMap<String, TexturePool>();

    TextureCache() {
    }

    public static TextureCache getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Texture acquireTexture(int width, int height) {
        String sizeKey = this.createSizeKey(width, height);
        TexturePool pool = this.sizePools.get(sizeKey);
        if (pool == null) {
            Map<String, TexturePool> map = this.sizePools;
            synchronized (map) {
                pool = this.sizePools.get(sizeKey);
                if (pool == null) {
                    pool = new TexturePool(width, height);
                    this.sizePools.put(sizeKey, pool);
                }
            }
        }
        return pool.acquire();
    }

    public void releaseTexture(Texture texture) {
        if (texture == null) {
            return;
        }
        String sizeKey = this.createSizeKey(texture.width(), texture.height());
        TexturePool pool = this.sizePools.get(sizeKey);
        if (pool != null) {
            pool.release(texture);
        } else {
            texture.delete();
        }
    }

    private String createSizeKey(int width, int height) {
        return width + "x" + height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, TexturePool> map = this.sizePools;
        synchronized (map) {
            for (TexturePool pool : this.sizePools.values()) {
                pool.clear();
            }
            this.sizePools.clear();
        }
    }

    private static class TexturePool {
        private final int width;
        private final int height;
        private final Queue<Texture> availableTextures = new ArrayDeque<Texture>();
        private final Set<Texture> inUseTextures = new HashSet<Texture>();

        TexturePool(int width, int height) {
            this.width = width;
            this.height = height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Texture acquire() {
            TexturePool texturePool = this;
            synchronized (texturePool) {
                Texture texture = this.availableTextures.poll();
                if (texture == null) {
                    texture = Texture.create(this.width, this.height);
                } else {
                    texture.reset();
                }
                this.inUseTextures.add(texture);
                return texture;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void release(Texture texture) {
            TexturePool texturePool = this;
            synchronized (texturePool) {
                if (this.inUseTextures.contains(texture)) {
                    this.inUseTextures.remove(texture);
                    if (texture.isInvalid()) {
                        texture.delete();
                    } else {
                        this.availableTextures.offer(texture);
                        while (this.availableTextures.size() > 20) {
                            Texture oldest = this.availableTextures.poll();
                            if (oldest == null) continue;
                            oldest.delete();
                        }
                    }
                } else {
                    texture.delete();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void clear() {
            TexturePool texturePool = this;
            synchronized (texturePool) {
                for (Texture texture : this.availableTextures) {
                    texture.delete();
                }
                this.availableTextures.clear();
                for (Texture texture : this.inUseTextures) {
                    texture.delete();
                }
                this.inUseTextures.clear();
            }
        }
    }
}

