/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.hoko.blur.util.Preconditions;
import java.nio.Buffer;

public class Texture {
    private int mTextureId;
    private final int mWidth;
    private final int mHeight;
    private volatile boolean deleted = false;

    public static Texture create(int width, int height) {
        Preconditions.checkArgument(width > 0 && height > 0, "width > 0 and height > 0");
        return new Texture(width, height);
    }

    private Texture(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        int[] textureIds = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureIds, (int)0);
        this.mTextureId = textureIds[0];
        this.reset();
        GLES20.glBindTexture((int)3553, (int)0);
    }

    public void delete() {
        if (this.deleted) {
            return;
        }
        if (this.mTextureId != 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
            this.deleted = true;
        }
    }

    public int id() {
        return this.mTextureId;
    }

    public int width() {
        return this.mWidth;
    }

    public int height() {
        return this.mHeight;
    }

    public boolean isInvalid() {
        return this.deleted || !GLES20.glIsTexture((int)this.mTextureId);
    }

    public void reset() {
        if (this.mTextureId != 0) {
            GLES20.glBindTexture((int)3553, (int)this.mTextureId);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width(), (int)this.height(), (int)0, (int)6408, (int)5121, (Buffer)null);
        }
    }

    public void uploadBitmap(Bitmap bitmap) {
        if (this.mTextureId != 0) {
            GLES20.glBindTexture((int)3553, (int)this.mTextureId);
            if (bitmap != null && !bitmap.isRecycled()) {
                GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            }
            GLES20.glBindTexture((int)3553, (int)0);
        }
    }
}

