/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import com.hoko.blur.opengl.Program;

class RefCountedProgram {
    private final Program program;
    private int refCount = 1;
    private volatile boolean deleted = false;

    RefCountedProgram(String vertexShaderCode, String fragmentShaderCode) {
        this.program = Program.of(vertexShaderCode, fragmentShaderCode);
    }

    Program getProgram() {
        return this.program;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean incrementRefCount() {
        RefCountedProgram refCountedProgram = this;
        synchronized (refCountedProgram) {
            if (this.isInvalid()) {
                return false;
            }
            ++this.refCount;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementRefCount() {
        RefCountedProgram refCountedProgram = this;
        synchronized (refCountedProgram) {
            --this.refCount;
            if (this.refCount <= 0) {
                this.deleted = true;
                this.program.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearRefCount() {
        RefCountedProgram refCountedProgram = this;
        synchronized (refCountedProgram) {
            this.refCount = 0;
            this.deleted = true;
            this.program.delete();
        }
    }

    int getRefCount() {
        return this.refCount;
    }

    boolean isInvalid() {
        return this.deleted || this.program.id() == 0;
    }
}

