/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import com.hoko.blur.opengl.Program;
import com.hoko.blur.opengl.RefCountedProgram;
import com.hoko.blur.util.ShaderUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ProgramManager {
    private final Map<Integer, RefCountedProgram> programCache = new ConcurrentHashMap<Integer, RefCountedProgram>();

    public static ProgramManager getInstance() {
        return ProgramManagerHolder.INSTANCE;
    }

    private ProgramManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Program getProgram(int mode) {
        ProgramManager programManager = this;
        synchronized (programManager) {
            RefCountedProgram refCountedProgram = this.programCache.get(mode);
            if (refCountedProgram != null) {
                if (refCountedProgram.incrementRefCount()) {
                    return refCountedProgram.getProgram();
                }
                refCountedProgram.clearRefCount();
                this.programCache.remove(mode);
            }
            refCountedProgram = new RefCountedProgram(ShaderUtil.getVertexCode(), ShaderUtil.getFragmentShaderCode(mode));
            this.programCache.put(mode, refCountedProgram);
            return refCountedProgram.getProgram();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseProgram(Program program) {
        if (program == null) {
            return;
        }
        ProgramManager programManager = this;
        synchronized (programManager) {
            Iterator<Map.Entry<Integer, RefCountedProgram>> it = this.programCache.entrySet().iterator();
            while (it.hasNext()) {
                RefCountedProgram refCountedProgram = it.next().getValue();
                if (refCountedProgram.getProgram() != program) continue;
                refCountedProgram.decrementRefCount();
                if (refCountedProgram.getRefCount() > 0) continue;
                it.remove();
                return;
            }
        }
        program.delete();
    }

    private static class ProgramManagerHolder {
        private static final ProgramManager INSTANCE = new ProgramManager();

        private ProgramManagerHolder() {
        }
    }
}

