/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import android.opengl.GLES20;
import android.util.Log;
import com.hoko.blur.util.ShaderUtil;

class Program {
    private static final String TAG = Program.class.getSimpleName();
    private int id;

    public static Program of(String vertexShaderCode, String fragmentShaderCode) {
        return new Program(vertexShaderCode, fragmentShaderCode);
    }

    private Program(String vertexShaderCode, String fragmentShaderCode) {
        this.create(vertexShaderCode, fragmentShaderCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(String vertexShaderCode, String fragmentShaderCode) {
        int vertexShader = 0;
        int fragmentShader = 0;
        try {
            vertexShader = this.loadShader(35633, vertexShaderCode);
            fragmentShader = this.loadShader(35632, fragmentShaderCode);
            if (vertexShader == 0 || fragmentShader == 0) {
                return;
            }
            this.id = GLES20.glCreateProgram();
            if (this.id != 0) {
                GLES20.glAttachShader((int)this.id, (int)vertexShader);
                GLES20.glAttachShader((int)this.id, (int)fragmentShader);
                GLES20.glLinkProgram((int)this.id);
                ShaderUtil.checkGLError("Attach Shader");
                int[] linkStatus = new int[1];
                GLES20.glGetProgramiv((int)this.id, (int)35714, (int[])linkStatus, (int)0);
                if (linkStatus[0] != 1) {
                    Log.e((String)TAG, (String)"Failed to link program");
                    GLES20.glDeleteProgram((int)this.id);
                    this.id = 0;
                }
            }
        }
        finally {
            GLES20.glDetachShader((int)this.id, (int)vertexShader);
            GLES20.glDetachShader((int)this.id, (int)fragmentShader);
            GLES20.glDeleteShader((int)vertexShader);
            GLES20.glDeleteShader((int)fragmentShader);
        }
    }

    public void delete() {
        if (this.id != 0) {
            GLES20.glUseProgram((int)0);
            GLES20.glDeleteProgram((int)this.id);
        }
    }

    private int loadShader(int type, String shaderCode) {
        int shader = GLES20.glCreateShader((int)type);
        if (shader != 0) {
            GLES20.glShaderSource((int)shader, (String)shaderCode);
            GLES20.glCompileShader((int)shader);
            int[] compiled = new int[1];
            GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
            if (compiled[0] == 0) {
                Log.e((String)TAG, (String)"Failed to compile the shader");
                GLES20.glDeleteShader((int)shader);
                shader = 0;
            }
        }
        return shader;
    }

    public int id() {
        return this.id;
    }
}

