/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.hoko.blur.anno.NotThreadSafe;
import com.hoko.blur.opengl.FrameBuffer;
import com.hoko.blur.opengl.FrameBufferCache;
import com.hoko.blur.opengl.IRenderer;
import com.hoko.blur.opengl.Program;
import com.hoko.blur.opengl.ProgramManager;
import com.hoko.blur.opengl.Texture;
import com.hoko.blur.opengl.TextureCache;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLContext;

@NotThreadSafe
class OffScreenBlurRenderer
implements IRenderer<Bitmap> {
    private static final String TAG = OffScreenBlurRenderer.class.getSimpleName();
    private static final int COORDS_PER_VERTEX = 3;
    private static final int VERTEX_STRIDE = 12;
    private static final float[] squareCoords = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] mTexHorizontalCoords = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    private static final short[] drawOrder = new short[]{0, 1, 2, 0, 2, 3};
    private final FloatBuffer mVertexBuffer;
    private final ShortBuffer mDrawListBuffer;
    private final FloatBuffer mTexCoordBuffer;
    private Program mProgram;
    private int mRadius;
    private int mMode;

    public OffScreenBlurRenderer(int mode, int radius) {
        this.mMode = mode;
        this.mRadius = radius;
        ByteBuffer bb = ByteBuffer.allocateDirect(squareCoords.length * 4);
        bb.order(ByteOrder.nativeOrder());
        this.mVertexBuffer = bb.asFloatBuffer();
        this.mVertexBuffer.put(squareCoords);
        this.mVertexBuffer.position(0);
        ByteBuffer dlb = ByteBuffer.allocateDirect(drawOrder.length * 2);
        dlb.order(ByteOrder.nativeOrder());
        this.mDrawListBuffer = dlb.asShortBuffer();
        this.mDrawListBuffer.put(drawOrder);
        this.mDrawListBuffer.position(0);
        ByteBuffer tcb = ByteBuffer.allocateDirect(mTexHorizontalCoords.length * 4);
        tcb.order(ByteOrder.nativeOrder());
        this.mTexCoordBuffer = tcb.asFloatBuffer();
        this.mTexCoordBuffer.put(mTexHorizontalCoords);
        this.mTexCoordBuffer.position(0);
        this.mProgram = ProgramManager.getInstance().getProgram(this.mMode);
    }

    @Override
    public void onDrawFrame(Bitmap bitmap) {
        if (bitmap == null || bitmap.isRecycled()) {
            return;
        }
        if (bitmap.getWidth() == 0 || bitmap.getHeight() == 0) {
            return;
        }
        BlurContext blurContext = null;
        try {
            blurContext = this.prepare(bitmap);
            this.draw(blurContext);
        }
        finally {
            this.onPostBlur(blurContext);
        }
    }

    private BlurContext prepare(Bitmap bitmap) {
        EGLContext context = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        if (context.equals(EGL10.EGL_NO_CONTEXT)) {
            throw new IllegalStateException("This thread has no EGLContext.");
        }
        if (this.mProgram == null || this.mProgram.id() == 0) {
            throw new IllegalStateException("Failed to create program.");
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        GLES20.glClear((int)16384);
        GLES20.glViewport((int)0, (int)0, (int)w, (int)h);
        return new BlurContext(bitmap);
    }

    private void draw(BlurContext blurContext) {
        this.drawOneDimenBlur(blurContext, true);
        this.drawOneDimenBlur(blurContext, false);
        GLES20.glFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawOneDimenBlur(BlurContext blurContext, boolean isHorizontal) {
        try {
            GLES20.glUseProgram((int)this.mProgram.id());
            int positionId = GLES20.glGetAttribLocation((int)this.mProgram.id(), (String)"aPosition");
            GLES20.glEnableVertexAttribArray((int)positionId);
            GLES20.glVertexAttribPointer((int)positionId, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)this.mVertexBuffer);
            int texCoordId = GLES20.glGetAttribLocation((int)this.mProgram.id(), (String)"aTexCoord");
            GLES20.glEnableVertexAttribArray((int)texCoordId);
            GLES20.glVertexAttribPointer((int)texCoordId, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)this.mTexCoordBuffer);
            if (isHorizontal) {
                blurContext.getBlurFrameBuffer().bindSelf();
            }
            int textureUniformId = GLES20.glGetUniformLocation((int)this.mProgram.id(), (String)"uTexture");
            GLES20.glActiveTexture((int)33984);
            GLES20.glBindTexture((int)3553, (int)(isHorizontal ? blurContext.getInputTexture().id() : blurContext.getHorizontalTexture().id()));
            GLES20.glUniform1i((int)textureUniformId, (int)0);
            int radiusId = GLES20.glGetUniformLocation((int)this.mProgram.id(), (String)"uRadius");
            int widthOffsetId = GLES20.glGetUniformLocation((int)this.mProgram.id(), (String)"uWidthOffset");
            int heightOffsetId = GLES20.glGetUniformLocation((int)this.mProgram.id(), (String)"uHeightOffset");
            GLES20.glUniform1i((int)radiusId, (int)this.mRadius);
            GLES20.glUniform1f((int)widthOffsetId, (float)(isHorizontal ? 0.0f : 1.0f / (float)blurContext.getBitmap().getWidth()));
            GLES20.glUniform1f((int)heightOffsetId, (float)(isHorizontal ? 1.0f / (float)blurContext.getBitmap().getHeight() : 0.0f));
            GLES20.glDrawElements((int)4, (int)drawOrder.length, (int)5123, (Buffer)this.mDrawListBuffer);
            if (!isHorizontal) {
                GLES20.glDisableVertexAttribArray((int)positionId);
                GLES20.glDisableVertexAttribArray((int)texCoordId);
            }
        }
        finally {
            this.resetAllBuffer();
        }
    }

    private void resetAllBuffer() {
        GLES20.glBindFramebuffer((int)36160, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glUseProgram((int)0);
        this.mVertexBuffer.rewind();
        this.mTexCoordBuffer.rewind();
        this.mDrawListBuffer.rewind();
    }

    private void onPostBlur(BlurContext blurContext) {
        if (blurContext != null) {
            blurContext.finish();
        }
        this.mVertexBuffer.clear();
        this.mTexCoordBuffer.clear();
        this.mDrawListBuffer.clear();
        this.releaseProgram();
    }

    private void releaseProgram() {
        if (this.mProgram != null) {
            ProgramManager.getInstance().releaseProgram(this.mProgram);
        }
    }

    private static class BlurContext {
        private final Texture inputTexture;
        private final Texture horizontalTexture;
        private final FrameBuffer blurFrameBuffer;
        private final Bitmap bitmap;

        private BlurContext(Bitmap bitmap) {
            this.bitmap = bitmap;
            this.inputTexture = TextureCache.getInstance().acquireTexture(bitmap.getWidth(), bitmap.getHeight());
            this.inputTexture.uploadBitmap(bitmap);
            this.horizontalTexture = TextureCache.getInstance().acquireTexture(bitmap.getWidth(), bitmap.getHeight());
            this.blurFrameBuffer = FrameBufferCache.getInstance().getFrameBuffer();
            if (this.blurFrameBuffer == null) {
                throw new IllegalStateException("Failed to create framebuffer.");
            }
            this.blurFrameBuffer.bindTexture(this.horizontalTexture);
        }

        private Texture getInputTexture() {
            return this.inputTexture;
        }

        private Texture getHorizontalTexture() {
            return this.horizontalTexture;
        }

        private FrameBuffer getBlurFrameBuffer() {
            return this.blurFrameBuffer;
        }

        private Bitmap getBitmap() {
            return this.bitmap;
        }

        private void finish() {
            this.blurFrameBuffer.unbindTexture();
            if (this.inputTexture != null) {
                TextureCache.getInstance().releaseTexture(this.inputTexture);
            }
            if (this.horizontalTexture != null) {
                TextureCache.getInstance().releaseTexture(this.horizontalTexture);
            }
            FrameBufferCache.getInstance().recycleFrameBuffer(this.blurFrameBuffer);
        }
    }
}

