/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import com.hoko.blur.opengl.CachePool;
import com.hoko.blur.opengl.FrameBuffer;

class FrameBufferCache {
    private final CachePool<Object, FrameBuffer> mCache = new CachePool<Object, FrameBuffer>(32){

        @Override
        protected FrameBuffer create(Object key) {
            return FrameBuffer.create();
        }

        @Override
        protected boolean checkHit(Object key, FrameBuffer frameBuffer) {
            return true;
        }

        @Override
        protected void entryDeleted(FrameBuffer frameBuffer) {
            if (frameBuffer != null) {
                frameBuffer.delete();
            }
        }
    };

    private FrameBufferCache() {
    }

    public static FrameBufferCache getInstance() {
        return FrameBufferCacheHolder.INSTANCE;
    }

    public FrameBuffer getFrameBuffer() {
        if (this.mCache != null) {
            return this.mCache.get(new Object());
        }
        return null;
    }

    public void recycleFrameBuffer(FrameBuffer frameBuffer) {
        if (frameBuffer != null) {
            this.mCache.put(frameBuffer);
        }
    }

    public void deleteFrameBuffers() {
        if (this.mCache != null) {
            this.mCache.evictAll();
        }
    }

    private static class FrameBufferCacheHolder {
        private static final FrameBufferCache INSTANCE = new FrameBufferCache();

        private FrameBufferCacheHolder() {
        }
    }
}

