/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.util.Log;
import com.hoko.blur.opengl.OffScreenBlurRenderer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public final class EglBuffer {
    private static final String TAG = EglBuffer.class.getSimpleName();
    private static final EGL10 EGL = (EGL10)EGLContext.getEGL();
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final int[] CONFIG_ATTRIB_LIST = new int[]{12320, 32, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 1, 12344};
    private final int[] CONTEXT_ATTRIB_LIST = new int[]{12440, 2, 12344};
    private EGLDisplay eglDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLContext eglContext = null;
    private final EGLConfig[] eglConfigs = new EGLConfig[1];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBlurBitmap(Bitmap bitmap, int radius, int mode) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        this.checkEGLContext();
        EGLSurface eglSurface = null;
        OffScreenBlurRenderer renderer = null;
        try {
            eglSurface = this.createSurface(w, h, this.eglDisplay, this.eglConfigs);
            EGL.eglMakeCurrent(this.eglDisplay, eglSurface, eglSurface, this.eglContext);
            renderer = this.createRenderer(radius, mode);
            renderer.onDrawFrame(bitmap);
            EGL.eglSwapBuffers(this.eglDisplay, eglSurface);
            this.convertToBitmap(bitmap);
            this.destroyEglSurface(this.eglDisplay, eglSurface);
        }
        catch (Throwable t) {
            try {
                Log.e((String)TAG, (String)"Blur the bitmap error", (Throwable)t);
                this.destroyEglSurface(this.eglDisplay, eglSurface);
            }
            catch (Throwable throwable) {
                this.destroyEglSurface(this.eglDisplay, eglSurface);
                throw throwable;
            }
        }
        return bitmap;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    private void release() {
        this.destroyEglContext(this.eglDisplay, this.eglContext);
    }

    private void checkEGLContext() {
        if (this.eglDisplay == EGL10.EGL_NO_DISPLAY) {
            this.eglDisplay = this.createDisplay(this.eglConfigs);
            this.eglContext = this.createEGLContext(this.eglDisplay, this.eglConfigs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertToBitmap(Bitmap bitmap) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        ByteBuffer buffer = null;
        try {
            buffer = ByteBuffer.allocateDirect(w * h * 4);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            GLES20.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (Buffer)buffer);
            buffer.rewind();
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
        }
        finally {
            if (buffer != null) {
                buffer.clear();
                buffer = null;
            }
        }
    }

    private EGLDisplay createDisplay(EGLConfig[] eglConfigs) {
        EGLDisplay eglDisplay = EGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        EGL.eglInitialize(eglDisplay, new int[2]);
        EGL.eglChooseConfig(eglDisplay, CONFIG_ATTRIB_LIST, eglConfigs, 1, new int[1]);
        return eglDisplay;
    }

    private EGLSurface createSurface(int width, int height, EGLDisplay eglDisplay, EGLConfig[] eglConfigs) {
        int[] surfaceAttrs = new int[]{12375, width, 12374, height, 12344};
        return EGL.eglCreatePbufferSurface(eglDisplay, eglConfigs[0], surfaceAttrs);
    }

    private void destroyEglSurface(EGLDisplay eglDisplay, EGLSurface eglSurface) {
        EGL.eglMakeCurrent(eglDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        if (eglSurface != null) {
            EGL.eglDestroySurface(eglDisplay, eglSurface);
        }
    }

    private EGLContext createEGLContext(EGLDisplay eglDisplay, EGLConfig[] eglConfigs) {
        return EGL.eglCreateContext(eglDisplay, eglConfigs[0], EGL10.EGL_NO_CONTEXT, this.CONTEXT_ATTRIB_LIST);
    }

    private void destroyEglContext(EGLDisplay eglDisplay, EGLContext eglContext) {
        EGL.eglDestroyContext(eglDisplay, eglContext);
    }

    private OffScreenBlurRenderer createRenderer(int radius, int mode) {
        return new OffScreenBlurRenderer(mode, radius);
    }
}

