/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.filter;

import android.graphics.Bitmap;
import com.hoko.blur.filter.BoxBlurFilter;
import com.hoko.blur.filter.GaussianBlurFilter;
import com.hoko.blur.filter.StackBlurFilter;
import com.hoko.blur.util.BitmapUtil;

public final class OriginBlurFilter {
    public static void doBlur(int mode, Bitmap bitmap, int radius, int cores, int index, int direction) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int x = 0;
        int y = 0;
        int deltaX = 0;
        int deltaY = 0;
        if (direction == 0) {
            deltaY = h / cores;
            y = index * deltaY;
            if (index == cores - 1) {
                deltaY = h - (cores - 1) * deltaY;
            }
            deltaX = w;
        } else if (direction == 1) {
            deltaX = w / cores;
            x = index * deltaX;
            if (index == cores - 1) {
                deltaX = w - (cores - 1) * deltaX;
            }
            deltaY = h;
        }
        int[] pixels = new int[deltaX * deltaY];
        bitmap.getPixels(pixels, 0, deltaX, x, y, deltaX, deltaY);
        switch (mode) {
            case 0: {
                BoxBlurFilter.doBlur(pixels, deltaX, deltaY, radius, direction);
                break;
            }
            case 1: {
                GaussianBlurFilter.doBlur(pixels, deltaX, deltaY, radius, direction);
                break;
            }
            case 2: {
                StackBlurFilter.doBlur(pixels, deltaX, deltaY, radius, direction);
            }
        }
        if (bitmap.isMutable()) {
            bitmap.setPixels(pixels, 0, deltaX, x, y, deltaX, deltaY);
        } else {
            BitmapUtil.replaceBitmap(bitmap, pixels, x, y, deltaX, deltaY);
        }
    }

    public static void doFullBlur(int mode, Bitmap bitmap, int radius) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pixels = new int[w * h];
        bitmap.getPixels(pixels, 0, w, 0, 0, w, h);
        switch (mode) {
            case 0: {
                BoxBlurFilter.doBlur(pixels, w, h, radius, 2);
                break;
            }
            case 1: {
                GaussianBlurFilter.doBlur(pixels, w, h, radius, 2);
                break;
            }
            case 2: {
                StackBlurFilter.doBlur(pixels, w, h, radius, 2);
            }
        }
        if (bitmap.isMutable()) {
            bitmap.setPixels(pixels, 0, w, 0, 0, w, h);
        } else {
            BitmapUtil.replaceBitmap(bitmap, pixels, 0, 0, w, h);
        }
    }
}

