/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.view.View;

public final class BitmapUtil {
    private static final Paint SCALE_PAINT = new Paint();

    public static Bitmap getScaledBitmap(Bitmap bitmap, float factor) {
        if (bitmap == null) {
            return null;
        }
        if (factor == 1.0f) {
            return bitmap;
        }
        float scale = 1.0f / factor;
        int newWidth = (int)((float)bitmap.getWidth() * scale);
        int newHeight = (int)((float)bitmap.getHeight() * scale);
        Bitmap scaledBitmap = Bitmap.createBitmap((int)newWidth, (int)newHeight, (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(scaledBitmap);
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(scale, scale);
        canvas.drawBitmap(bitmap, scaleMatrix, SCALE_PAINT);
        return scaledBitmap;
    }

    public static Bitmap getViewBitmap(View view, int translateX, int translateY, float sampleFactor) {
        float scale = 1.0f / sampleFactor;
        int width = view.getWidth();
        int height = view.getHeight();
        int downScaledWidth = (int)((float)(width - translateX) * scale);
        int downScaledHeight = (int)((float)(height - translateY) * scale);
        Bitmap bitmap = Bitmap.createBitmap((int)downScaledWidth, (int)downScaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (view.getBackground() != null && view.getBackground() instanceof ColorDrawable) {
            bitmap.eraseColor(((ColorDrawable)view.getBackground()).getColor());
        } else {
            bitmap.eraseColor(0);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.translate((float)(-((int)((float)translateX * scale))), (float)(-((int)((float)translateY * scale))));
        if (sampleFactor > 1.0f) {
            canvas.scale(scale, scale);
        }
        view.draw(canvas);
        return bitmap;
    }

    public static Bitmap transformBitmap(Bitmap bitmap, int translateX, int translateY) {
        if (translateX == 0 && translateY == 0) {
            return bitmap;
        }
        return Bitmap.createBitmap((Bitmap)bitmap, (int)translateX, (int)translateY, (int)(bitmap.getWidth() - translateX), (int)(bitmap.getHeight() - translateY));
    }

    public static synchronized native void replaceBitmap(Bitmap var0, int[] var1, int var2, int var3, int var4, int var5);

    static {
        System.loadLibrary("hoko_blur");
    }
}

