/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.task;

import android.graphics.Bitmap;
import com.hoko.blur.filter.NativeBlurFilter;
import com.hoko.blur.filter.OriginBlurFilter;
import com.hoko.blur.util.Preconditions;
import java.util.concurrent.Callable;

public final class BlurSubTask
implements Callable<Void> {
    private final int mScheme;
    private final int mMode;
    private final Bitmap mBitmapOut;
    private final int mRadius;
    private final int mIndex;
    private final int mCores;
    private final int mDirection;

    public BlurSubTask(int scheme, int mode, Bitmap bitmapOut, int radius, int cores, int index, int direction) {
        this.mScheme = scheme;
        this.mMode = mode;
        this.mBitmapOut = bitmapOut;
        this.mRadius = radius;
        this.mIndex = index;
        this.mCores = cores;
        this.mDirection = direction;
    }

    @Override
    public Void call() {
        Preconditions.checkNotNull(this.mBitmapOut, "mBitmapOut == null");
        Preconditions.checkArgument(!this.mBitmapOut.isRecycled(), "You must input an unrecycled bitmap !");
        Preconditions.checkArgument(this.mCores > 0, "mCores < 0");
        this.applyPixelsBlur();
        return null;
    }

    private void applyPixelsBlur() {
        switch (this.mScheme) {
            case 1003: {
                NativeBlurFilter.doBlur(this.mMode, this.mBitmapOut, this.mRadius, this.mCores, this.mIndex, this.mDirection);
                break;
            }
            case 1004: {
                OriginBlurFilter.doBlur(this.mMode, this.mBitmapOut, this.mRadius, this.mCores, this.mIndex, this.mDirection);
                break;
            }
            case 1002: {
                throw new UnsupportedOperationException("Blur in parallel not supported !");
            }
            case 1001: {
                break;
            }
        }
    }
}

