/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import com.hoko.blur.opengl.BitmapTexture;
import com.hoko.blur.opengl.SimpleTexture;
import com.hoko.blur.util.Preconditions;

public abstract class Texture {
    private int mTextureId;
    private int mWidth;
    private int mHeight;

    public static Texture create(int width, int height) {
        Preconditions.checkArgument(width > 0 && height > 0, "width > 0 and height > 0");
        return new SimpleTexture(width, height);
    }

    public static Texture create(Bitmap bitmap) {
        Preconditions.checkNotNull(bitmap, "bitmap == null");
        Preconditions.checkArgument(!bitmap.isRecycled(), "bitmap is recycled");
        return new BitmapTexture(bitmap);
    }

    public Texture(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    protected void create() {
        int[] textureIds = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureIds, (int)0);
        this.mTextureId = textureIds[0];
        if (this.mTextureId != 0) {
            GLES20.glBindTexture((int)3553, (int)this.mTextureId);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            this.onTextureCreated();
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    protected abstract void onTextureCreated();

    public void delete() {
        if (this.mTextureId != 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
        }
    }

    public int id() {
        return this.mTextureId;
    }

    public int width() {
        return this.mWidth;
    }

    public int height() {
        return this.mHeight;
    }
}

