/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.texture;

import android.opengl.GLES20;
import com.hoko.blur.api.ITexture;

public abstract class Texture
implements ITexture {
    private int mTextureId;
    private int mWidth;
    private int mHeight;

    public Texture(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
    }

    @Override
    public void create() {
        int[] textureIds = new int[1];
        GLES20.glGenTextures((int)1, (int[])textureIds, (int)0);
        this.mTextureId = textureIds[0];
        if (this.mTextureId != 0) {
            GLES20.glBindTexture((int)3553, (int)this.mTextureId);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
            this.onTextureCreated();
        }
        GLES20.glBindTexture((int)3553, (int)0);
    }

    protected abstract void onTextureCreated();

    @Override
    public void delete() {
        if (this.mTextureId != 0) {
            GLES20.glDeleteTextures((int)1, (int[])new int[]{this.mTextureId}, (int)0);
        }
    }

    @Override
    public int id() {
        return this.mTextureId;
    }

    @Override
    public int width() {
        return this.mWidth;
    }

    @Override
    public int height() {
        return this.mHeight;
    }
}

