/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import androidx.renderscript.Allocation;
import androidx.renderscript.Element;
import androidx.renderscript.RSRuntimeException;
import androidx.renderscript.RenderScript;
import androidx.renderscript.ScriptIntrinsicBlur;
import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.processor.HokoBlurBuild;
import com.hoko.blur.renderscript.ScriptC_BoxBlur;
import com.hoko.blur.renderscript.ScriptC_StackBlur;
import com.hoko.blur.util.MathUtil;
import com.hoko.blur.util.Preconditions;

class RenderScriptBlurProcessor
extends BlurProcessor {
    private static final String TAG = RenderScriptBlurProcessor.class.getSimpleName();
    private RenderScript mRenderScript;
    private ScriptIntrinsicBlur mGaussianBlurScript;
    private ScriptC_BoxBlur mBoxBlurScript;
    private ScriptC_StackBlur mStackBlurScript;
    private static final int RS_MAX_RADIUS = 25;
    private volatile boolean rsRuntimeInitialized = false;

    RenderScriptBlurProcessor(HokoBlurBuild builder) {
        super(builder);
        this.init(builder.mCtx);
    }

    private void init(Context context) {
        Preconditions.checkNotNull(context, "Please set context for renderscript scheme, forget to set context for builder?");
        try {
            this.mRenderScript = RenderScript.create((Context)context.getApplicationContext());
            this.mGaussianBlurScript = ScriptIntrinsicBlur.create((RenderScript)this.mRenderScript, (Element)Element.U8_4((RenderScript)this.mRenderScript));
            this.mBoxBlurScript = new ScriptC_BoxBlur(this.mRenderScript);
            this.mStackBlurScript = new ScriptC_StackBlur(this.mRenderScript);
            this.rsRuntimeInitialized = true;
        }
        catch (RSRuntimeException e) {
            Log.e((String)TAG, (String)"Failed to init RenderScript runtime", (Throwable)e);
            this.rsRuntimeInitialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Bitmap doInnerBlur(Bitmap bitmap, boolean concurrent) {
        Preconditions.checkNotNull(bitmap, "scaledInBitmap == null");
        if (!this.rsRuntimeInitialized) {
            Log.e((String)TAG, (String)"RenderScript Runtime is not initialized");
            return bitmap;
        }
        Allocation allocationIn = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)bitmap);
        Allocation allocationOut = Allocation.createFromBitmap((RenderScript)this.mRenderScript, (Bitmap)Bitmap.createBitmap((Bitmap)bitmap));
        try {
            switch (this.mMode) {
                case 0: {
                    this.doBoxBlur(bitmap, allocationIn, allocationOut);
                    allocationIn.copyTo(bitmap);
                    return bitmap;
                }
                case 2: {
                    this.doStackBlur(bitmap, allocationIn, allocationOut);
                    allocationIn.copyTo(bitmap);
                    return bitmap;
                }
                case 1: {
                    this.doGaussianBlur(allocationIn, allocationOut);
                    allocationOut.copyTo(bitmap);
                    return bitmap;
                }
            }
            return bitmap;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Blur the bitmap error", (Throwable)e);
            return bitmap;
        }
        finally {
            allocationIn.destroy();
            allocationOut.destroy();
        }
    }

    private void doBoxBlur(Bitmap input, Allocation in, Allocation out) {
        if (this.mBoxBlurScript == null) {
            throw new IllegalStateException("The blur script is unavailable");
        }
        this.mBoxBlurScript.set_input(in);
        this.mBoxBlurScript.set_output(out);
        this.mBoxBlurScript.set_width(input.getWidth());
        this.mBoxBlurScript.set_height(input.getHeight());
        this.mBoxBlurScript.set_radius(this.mRadius);
        this.mBoxBlurScript.forEach_boxblur_h(in);
        this.mBoxBlurScript.set_input(out);
        this.mBoxBlurScript.set_output(in);
        this.mBoxBlurScript.forEach_boxblur_v(out);
    }

    private void doGaussianBlur(Allocation in, Allocation out) {
        if (this.mGaussianBlurScript == null) {
            throw new IllegalStateException("The blur script is unavailable");
        }
        this.mRadius = MathUtil.clamp(this.mRadius, 0, 25);
        this.mGaussianBlurScript.setRadius((float)this.mRadius);
        this.mGaussianBlurScript.setInput(in);
        this.mGaussianBlurScript.forEach(out);
    }

    private void doStackBlur(Bitmap input, Allocation in, Allocation out) {
        if (this.mStackBlurScript == null) {
            throw new IllegalStateException("The blur script is unavailable");
        }
        this.mStackBlurScript.set_input(in);
        this.mStackBlurScript.set_output(out);
        this.mStackBlurScript.set_width(input.getWidth());
        this.mStackBlurScript.set_height(input.getHeight());
        this.mStackBlurScript.set_radius(this.mRadius);
        this.mStackBlurScript.forEach_stackblur_v(in);
        this.mStackBlurScript.set_input(out);
        this.mStackBlurScript.set_output(in);
        this.mStackBlurScript.forEach_stackblur_h(out);
    }
}

