/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.framebuffer;

import android.opengl.GLES20;
import com.hoko.blur.api.IFrameBuffer;
import com.hoko.blur.api.ITexture;

class FrameBuffer
implements IFrameBuffer {
    private int mFrameBufferId;
    private ITexture mTexture;

    FrameBuffer() {
        this.create();
    }

    FrameBuffer(int id) {
        this.mFrameBufferId = id;
    }

    public int id() {
        return this.mFrameBufferId;
    }

    public void id(int frameBufferId) {
        this.mFrameBufferId = frameBufferId;
    }

    @Override
    public void create() {
        int[] frameBufferIds = new int[1];
        GLES20.glGenFramebuffers((int)1, (int[])frameBufferIds, (int)0);
        this.mFrameBufferId = frameBufferIds[0];
    }

    @Override
    public void bindTexture(ITexture texture) {
        if (texture == null) {
            return;
        }
        this.mTexture = texture;
        if (texture.id() != 0) {
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferId);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)texture.id(), (int)0);
        }
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    public ITexture bindTexture() {
        return this.mTexture;
    }

    @Override
    public void bindSelf() {
        if (this.mFrameBufferId != 0) {
            GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferId);
        }
    }

    @Override
    public void delete() {
        if (this.mFrameBufferId != 0) {
            GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{this.mFrameBufferId}, (int)0);
        }
    }
}

