/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.graphics.Bitmap;
import android.util.Log;
import com.hoko.blur.filter.OriginBlurFilter;
import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.processor.HokoBlurBuild;
import com.hoko.blur.task.BlurSubTask;
import com.hoko.blur.task.BlurTaskManager;
import com.hoko.blur.util.Preconditions;
import java.util.ArrayList;

class OriginBlurProcessor
extends BlurProcessor {
    private static final String TAG = OriginBlurProcessor.class.getSimpleName();

    OriginBlurProcessor(HokoBlurBuild builder) {
        super(builder);
    }

    @Override
    protected Bitmap doInnerBlur(Bitmap scaledInBitmap, boolean concurrent) {
        Preconditions.checkNotNull(scaledInBitmap, "scaledInBitmap == null");
        try {
            if (concurrent) {
                int cores = BlurTaskManager.getWorkersNum();
                ArrayList<BlurSubTask> hTasks = new ArrayList<BlurSubTask>(cores);
                ArrayList<BlurSubTask> vTasks = new ArrayList<BlurSubTask>(cores);
                for (int i = 0; i < cores; ++i) {
                    hTasks.add(new BlurSubTask(1004, this.mMode, scaledInBitmap, this.mRadius, cores, i, 0));
                    vTasks.add(new BlurSubTask(1004, this.mMode, scaledInBitmap, this.mRadius, cores, i, 1));
                }
                BlurTaskManager.getInstance().invokeAll(hTasks);
                BlurTaskManager.getInstance().invokeAll(vTasks);
            } else {
                OriginBlurFilter.doFullBlur(this.mMode, scaledInBitmap, this.mRadius);
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"Blur the bitmap error", (Throwable)e);
        }
        return scaledInBitmap;
    }
}

