/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.hoko.blur.HokoBlur;
import com.hoko.blur.api.IBlurProcessor;

public class DragBlurringView
extends View {
    private static final int DOWNSAMPLE_FACTOR = 5;
    private float mOldX;
    private float mOldY;
    private View mBlurredView;
    private Bitmap mToBlurBitmap;
    private Canvas mBlurringCanvas;
    private IBlurProcessor mProcessor;

    public DragBlurringView(Context context) {
        super(context);
        this.init();
    }

    public DragBlurringView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mProcessor = HokoBlur.with(this.getContext()).scheme(1003).mode(1).radius(5).sampleFactor(1.0f).processor();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mBlurredView != null && this.prepare()) {
            if (this.mBlurredView.getBackground() != null && this.mBlurredView.getBackground() instanceof ColorDrawable) {
                this.mToBlurBitmap.eraseColor(((ColorDrawable)this.mBlurredView.getBackground()).getColor());
            } else {
                this.mToBlurBitmap.eraseColor(0);
            }
            this.mBlurredView.draw(this.mBlurringCanvas);
            Bitmap blurredBitmap = this.mProcessor.blur(this.mToBlurBitmap);
            canvas.save();
            canvas.translate(this.mBlurredView.getX() - this.getX(), this.mBlurredView.getY() - this.getY());
            canvas.scale(5.0f, 5.0f);
            canvas.drawBitmap(blurredBitmap, 0.0f, 0.0f, null);
            canvas.restore();
        }
    }

    private boolean prepare() {
        int width = this.mBlurredView.getWidth();
        int height = this.mBlurredView.getHeight();
        if (this.mBlurringCanvas == null) {
            int scaledWidth = width / 5;
            int scaleHeight = height / 5;
            if (this.mToBlurBitmap == null) {
                this.mToBlurBitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaleHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            if (this.mToBlurBitmap == null) {
                return false;
            }
            this.mBlurringCanvas = new Canvas(this.mToBlurBitmap);
            this.mBlurringCanvas.scale(0.2f, 0.2f);
        }
        return true;
    }

    public void setBlurredView(View blurredView) {
        this.mBlurredView = blurredView;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.mOldX = event.getRawX();
                this.mOldY = event.getRawY();
                return true;
            }
            case 2: {
                float dx = event.getRawX() - this.mOldX;
                float dy = event.getRawY() - this.mOldY;
                this.offsetLeftAndRight((int)dx);
                this.offsetTopAndBottom((int)dy);
                this.mOldX = event.getRawX();
                this.mOldY = event.getRawY();
                this.invalidate();
                break;
            }
        }
        return super.onTouchEvent(event);
    }
}

