/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.task;

import android.graphics.Bitmap;
import com.hoko.blur.api.IBlurProcessor;
import com.hoko.blur.api.IBlurResultDispatcher;
import com.hoko.blur.task.BlurResult;
import com.hoko.blur.task.BlurResultRunnable;
import com.hoko.blur.util.Preconditions;

public abstract class AsyncBlurTask<T>
implements Runnable {
    private Callback mCallback;
    IBlurProcessor mProcessor;
    private T mTarget;
    private IBlurResultDispatcher mResultDispatcher;

    public AsyncBlurTask(IBlurProcessor processor, T target, Callback callback, IBlurResultDispatcher dispatcher) {
        this.mProcessor = processor;
        this.mTarget = target;
        this.mCallback = callback;
        this.mResultDispatcher = dispatcher;
    }

    @Override
    public void run() {
        BlurResult result = new BlurResult(this.mCallback);
        try {
            if (this.mProcessor == null) {
                result.setSuccess(false);
                return;
            }
            result.setBitmap(this.makeBlur(this.mTarget));
            result.setSuccess(true);
        }
        catch (Throwable e) {
            e.printStackTrace();
            result.setSuccess(false);
            result.setError(e);
        }
        finally {
            Preconditions.checkNotNull(this.mResultDispatcher, "dispatcher == null");
            this.mResultDispatcher.dispatch(BlurResultRunnable.of(result));
        }
    }

    protected abstract Bitmap makeBlur(T var1);

    public static interface Callback {
        public void onBlurSuccess(Bitmap var1);

        public void onBlurFailed(Throwable var1);
    }
}

