/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import com.hoko.blur.processor.BlurProcessor;
import com.hoko.blur.processor.HokoBlurBuild;
import com.hoko.blur.processor.NativeBlurProcessor;
import com.hoko.blur.processor.OpenGLBlurProcessor;
import com.hoko.blur.processor.OriginBlurProcessor;
import com.hoko.blur.processor.RenderScriptBlurProcessor;

class BlurProcessorFactory {
    BlurProcessorFactory() {
    }

    static BlurProcessor getBlurProcessor(int scheme, HokoBlurBuild builder) {
        BlurProcessor blurProcessor = null;
        switch (scheme) {
            case 1001: {
                blurProcessor = new RenderScriptBlurProcessor(builder);
                break;
            }
            case 1002: {
                blurProcessor = new OpenGLBlurProcessor(builder);
                break;
            }
            case 1003: {
                blurProcessor = new NativeBlurProcessor(builder);
                break;
            }
            case 1004: {
                blurProcessor = new OriginBlurProcessor(builder);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported blur scheme!");
            }
        }
        return blurProcessor;
    }
}

