/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.processor;

import android.graphics.Bitmap;
import android.view.View;
import com.hoko.blur.api.IBlurProcessor;
import com.hoko.blur.api.IBlurResultDispatcher;
import com.hoko.blur.processor.HokoBlurBuild;
import com.hoko.blur.task.AsyncBlurTask;
import com.hoko.blur.task.BitmapAsyncBlurTask;
import com.hoko.blur.task.BlurTaskManager;
import com.hoko.blur.task.ViewAsyncBlurTask;
import com.hoko.blur.util.BitmapUtil;
import com.hoko.blur.util.Preconditions;
import java.util.concurrent.Future;

public abstract class BlurProcessor
implements IBlurProcessor {
    int mRadius;
    int mMode;
    private int mScheme;
    private float mSampleFactor;
    private boolean mIsForceCopy;
    private boolean mNeedUpscale;
    private int mTranslateX;
    private int mTranslateY;
    private IBlurResultDispatcher mDispatcher;

    public BlurProcessor(HokoBlurBuild builder) {
        this.mMode = builder.mMode;
        this.mScheme = builder.mScheme;
        this.mRadius = builder.mRadius;
        this.mSampleFactor = builder.mSampleFactor;
        this.mIsForceCopy = builder.mIsForceCopy;
        this.mNeedUpscale = builder.mNeedUpscale;
        this.mTranslateX = builder.mTranslateX;
        this.mTranslateY = builder.mTranslateY;
        this.mDispatcher = builder.mDispatcher;
    }

    public void mode(int mode) {
        this.mMode = mode;
    }

    public void radius(int radius) {
        this.mRadius = radius;
    }

    public void sampleFactor(float factor) {
        this.mSampleFactor = factor;
    }

    public int mode() {
        return this.mMode;
    }

    public int radius() {
        return this.mRadius;
    }

    public float sampleFactor() {
        return this.mSampleFactor;
    }

    public int scheme() {
        return this.mScheme;
    }

    public boolean forceCopy() {
        return this.mIsForceCopy;
    }

    public boolean needUpscale() {
        return this.mNeedUpscale;
    }

    public int translateX() {
        return this.mTranslateX;
    }

    public int translateY() {
        return this.mTranslateY;
    }

    @Override
    public Bitmap blur(Bitmap bitmap) {
        return this.doBlur(bitmap, true);
    }

    private Bitmap doBlur(Bitmap bitmap, boolean concurrent) {
        Preconditions.checkNotNull(bitmap, "bitmap == null");
        Preconditions.checkArgument(!bitmap.isRecycled(), "You must input an unrecycled bitmap !");
        if (this.mRadius <= 0) {
            this.mRadius = 1;
        }
        if (this.mSampleFactor < 1.0f) {
            this.mSampleFactor = 1.0f;
        }
        Bitmap inBitmap = null;
        inBitmap = this.mIsForceCopy ? bitmap.copy(bitmap.getConfig(), true) : bitmap;
        Bitmap transInBitmap = BitmapUtil.transformBitmap(inBitmap, this.translateX(), this.translateY());
        Bitmap scaledInBitmap = BitmapUtil.getScaledBitmap(transInBitmap, this.sampleFactor());
        Bitmap scaledOutBitmap = this.doInnerBlur(scaledInBitmap, concurrent);
        return this.mNeedUpscale ? BitmapUtil.getScaledBitmap(scaledOutBitmap, 1.0f / this.sampleFactor()) : scaledOutBitmap;
    }

    protected abstract Bitmap doInnerBlur(Bitmap var1, boolean var2);

    @Override
    public Bitmap blur(View view) {
        Preconditions.checkNotNull(view, "You must input a view !");
        Bitmap viewBitmap = BitmapUtil.getViewBitmap(view, this.translateX(), this.translateY(), this.sampleFactor());
        Bitmap scaledOutBitmap = this.doInnerBlur(viewBitmap, true);
        return this.mNeedUpscale ? BitmapUtil.getScaledBitmap(scaledOutBitmap, 1.0f / this.sampleFactor()) : scaledOutBitmap;
    }

    @Override
    public Future asyncBlur(Bitmap bitmap, AsyncBlurTask.Callback callback) {
        return BlurTaskManager.getInstance().submit(new BitmapAsyncBlurTask((IBlurProcessor)this, bitmap, callback, this.mDispatcher));
    }

    @Override
    public Future asyncBlur(View view, AsyncBlurTask.Callback callback) {
        return BlurTaskManager.getInstance().submit(new ViewAsyncBlurTask((IBlurProcessor)this, view, callback, this.mDispatcher));
    }

    protected void free() {
    }
}

