/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.offscreen;

import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.util.Log;
import com.hoko.blur.opengl.offscreen.OffScreenBlurRenderer;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EglBuffer {
    private static final String TAG = EglBuffer.class.getSimpleName();
    private EGL10 mEgl;
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLSurface mEGLSurface;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private EGLConfig[] mEglConfigs = new EGLConfig[1];
    private int[] mContextAttrs = new int[]{12440, 2, 12344};
    private ThreadLocal<OffScreenBlurRenderer> mThreadRenderer = new ThreadLocal();
    private ThreadLocal<EGLContext> mThreadEGLContext = new ThreadLocal();

    public EglBuffer() {
        this.initGL();
    }

    private void initGL() {
        int[] configAttribs = new int[]{12320, 32, 12321, 8, 12322, 8, 12323, 8, 12324, 8, 12352, 4, 12339, 1, 12344};
        this.mEgl = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEgl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        this.mEgl.eglInitialize(this.mEGLDisplay, new int[2]);
        this.mEgl.eglChooseConfig(this.mEGLDisplay, configAttribs, this.mEglConfigs, 1, new int[1]);
    }

    private EGLSurface createSurface(int width, int height) {
        int[] surfaceAttrs = new int[]{12375, width, 12374, height, 12344};
        EGLSurface eglSurface = this.mEgl.eglCreatePbufferSurface(this.mEGLDisplay, this.mEglConfigs[0], surfaceAttrs);
        this.mEgl.eglMakeCurrent(this.mEGLDisplay, eglSurface, eglSurface, this.getEGLContext());
        return eglSurface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBlurBitmap(Bitmap bitmap) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        try {
            this.mEGLSurface = this.createSurface(w, h);
            if (this.mEGLSurface == null) {
                Log.e((String)TAG, (String)"Create surface error");
                Bitmap bitmap2 = bitmap;
                return bitmap2;
            }
            OffScreenBlurRenderer renderer = this.getRenderer();
            if (renderer == null) {
                Log.e((String)TAG, (String)"Renderer is unavailable");
                Bitmap bitmap3 = bitmap;
                return bitmap3;
            }
            renderer.onDrawFrame(bitmap);
            this.mEgl.eglSwapBuffers(this.mEGLDisplay, this.mEGLSurface);
            this.convertToBitmap(bitmap);
        }
        catch (Throwable t) {
            Log.e((String)TAG, (String)"Blur the bitmap error", (Throwable)t);
        }
        finally {
            this.destroyEglSurface();
        }
        return bitmap;
    }

    private void convertToBitmap(Bitmap bitmap) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        IntBuffer ib = IntBuffer.allocate(w * h);
        GLES20.glReadPixels((int)0, (int)0, (int)w, (int)h, (int)6408, (int)5121, (Buffer)ib);
        int[] ia = ib.array();
        bitmap.copyPixelsFromBuffer((Buffer)IntBuffer.wrap(ia));
    }

    private void destroyEglSurface() {
        this.mEgl.eglMakeCurrent(this.mEGLDisplay, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT);
        if (this.mEGLSurface != null) {
            this.mEgl.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface);
        }
    }

    private OffScreenBlurRenderer getRenderer() {
        OffScreenBlurRenderer renderer = this.mThreadRenderer.get();
        if (renderer == null) {
            renderer = new OffScreenBlurRenderer();
            this.mThreadRenderer.set(renderer);
        }
        return renderer;
    }

    private EGLContext getEGLContext() {
        EGLContext eglContext = this.mThreadEGLContext.get();
        if (eglContext == null) {
            eglContext = this.mEgl.eglCreateContext(this.mEGLDisplay, this.mEglConfigs[0], EGL10.EGL_NO_CONTEXT, this.mContextAttrs);
            this.mThreadEGLContext.set(eglContext);
        }
        return eglContext;
    }

    public void setBlurRadius(int radius) {
        this.getRenderer().setBlurRadius(radius);
    }

    public void setBlurMode(int mode) {
        this.getRenderer().setBlurMode(mode);
    }

    public void free() {
        this.getRenderer().free();
        EGLContext eglContext = this.mThreadEGLContext.get();
        if (eglContext != null) {
            this.mEgl.eglDestroyContext(this.mEGLDisplay, eglContext);
        }
        this.mThreadEGLContext.set(null);
    }
}

