/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.cache;

import com.hoko.blur.util.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class CachePool<K, V> {
    private static final int MAX_SIZE = 1024;
    private int mMaxSize;
    private List<V> mInternalCache;

    public CachePool() {
        this(1024);
    }

    public CachePool(int maxSize) {
        Preconditions.checkArgument(maxSize > 0, "maxSize <= 0");
        this.mMaxSize = maxSize;
        this.mInternalCache = new LinkedList<V>();
    }

    public final V get(K key) {
        Preconditions.checkNotNull(key, "size == null");
        V listValue = this.remove(key);
        if (listValue != null) {
            return listValue;
        }
        return this.create(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(V v) {
        block7: {
            Preconditions.checkNotNull(v, "value == null");
            try {
                if (this.mInternalCache.contains(v)) break block7;
                CachePool cachePool = this;
                synchronized (cachePool) {
                    if (!this.mInternalCache.contains(v)) {
                        this.mInternalCache.add(v);
                    }
                }
            }
            finally {
                this.trimToSize(this.mMaxSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V remove(K key) {
        Preconditions.checkNotNull(key, "key == null");
        V previous = null;
        CachePool cachePool = this;
        synchronized (cachePool) {
            Iterator<V> it = this.mInternalCache.iterator();
            while (it.hasNext()) {
                V value = it.next();
                if (!this.checkHit(key, value)) continue;
                it.remove();
                previous = value;
                break;
            }
        }
        return previous;
    }

    public void delete(K key) {
        Preconditions.checkNotNull(key, "key == null");
        V removed = this.remove(key);
        if (removed != null) {
            this.entryDeleted(removed);
        }
    }

    protected V create(K key) {
        return null;
    }

    protected void entryDeleted(V v) {
    }

    protected abstract boolean checkHit(K var1, V var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimToSize(int maxSize) {
        ArrayList<V> removedCollection = new ArrayList<V>();
        CachePool cachePool = this;
        synchronized (cachePool) {
            while (this.mInternalCache.size() > maxSize && !this.mInternalCache.isEmpty()) {
                Object removed = this.mInternalCache.remove(0);
                if (removed == null) continue;
                removedCollection.add(removed);
            }
        }
        for (Object removed : removedCollection) {
            if (removed == null) continue;
            this.entryDeleted(removed);
        }
    }

    public final synchronized int maxSize() {
        return this.mMaxSize;
    }

    public final void evictAll() {
        this.trimToSize(-1);
    }
}

