/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.filter;

final class StackBlurFilter {
    StackBlurFilter() {
    }

    public static void doBlur(int[] pix, int w, int h, int radius, int direction) {
        if (direction == 0) {
            StackBlurFilter.doHorizontalBlur(pix, w, h, radius);
        } else if (direction == 1) {
            StackBlurFilter.doVerticalBlur(pix, w, h, radius);
        } else {
            StackBlurFilter.doHorizontalBlur(pix, w, h, radius);
            StackBlurFilter.doVerticalBlur(pix, w, h, radius);
        }
    }

    private static void doHorizontalBlur(int[] pix, int w, int h, int radius) {
        int i;
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (int y = 0; y < h; ++y) {
            int[] sir;
            int p;
            int bsum = 0;
            int gsum = 0;
            int rsum = 0;
            int boutsum = 0;
            int goutsum = 0;
            int routsum = 0;
            int binsum = 0;
            int ginsum = 0;
            int rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                int rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            int stackpointer = radius;
            for (int x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                int stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
    }

    private static void doVerticalBlur(int[] pix, int w, int h, int radius) {
        int i;
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (i = 0; i < wh; ++i) {
            r[i] = (pix[i] & 0xFF0000) >> 16;
            g[i] = (pix[i] & 0xFF00) >> 8;
            b[i] = pix[i] & 0xFF;
        }
        for (int x = 0; x < w; ++x) {
            int[] sir;
            int bsum = 0;
            int gsum = 0;
            int rsum = 0;
            int boutsum = 0;
            int goutsum = 0;
            int routsum = 0;
            int binsum = 0;
            int ginsum = 0;
            int rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                int rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            int stackpointer = radius;
            for (int y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                int stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                int p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
    }
}

