/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import android.widget.LinearLayout;
import com.hoko.blur.HokoBlur;
import com.hoko.blur.processor.BlurProcessor;

public class RsBlurLinearLayout
extends LinearLayout {
    private static final int DEFAULT_BLUR_RADIUS = 5;
    private static final float DEFAULT_BITMAP_SAMPLE_FACTOR = 5.0f;
    private int[] mLocationInWindow;
    private BlurProcessor mProcessor;
    private Bitmap mBitmap;
    private Canvas mCanvas;
    private final ViewTreeObserver.OnPreDrawListener mOnPreDrawListener = () -> {
        if (this.getVisibility() == 0) {
            this.prepare();
        }
        return true;
    };

    public RsBlurLinearLayout(Context context) {
        super(context);
        this.init();
    }

    public RsBlurLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public RsBlurLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mCanvas = new Canvas();
        this.mLocationInWindow = new int[2];
        this.mProcessor = HokoBlur.with(this.getContext()).scheme(1001).sampleFactor(5.0f).processor();
        this.setBlurRadius(5);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mCanvas == canvas) {
            this.mBitmap = this.mProcessor.blur(this.mBitmap);
        } else {
            if (this.mBitmap != null) {
                canvas.drawBitmap(this.mBitmap, new Matrix(), null);
            }
            super.dispatchDraw(canvas);
        }
    }

    public void setBlurRadius(int radius) {
        this.mProcessor.radius(radius);
        this.invalidate();
    }

    public void setSampleFactor(float factor) {
        this.mProcessor.sampleFactor(factor);
        this.invalidate();
    }

    private void prepare() {
        int width = this.getWidth();
        int height = this.getHeight();
        width = Math.max(width, 1);
        height = Math.max(height, 1);
        if (this.mBitmap == null || this.mBitmap.getWidth() != width || this.mBitmap.getHeight() != height) {
            this.mBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        this.getLocationInWindow(this.mLocationInWindow);
        this.mCanvas.restoreToCount(1);
        this.mCanvas.setBitmap(this.mBitmap);
        this.mCanvas.setMatrix(new Matrix());
        this.mCanvas.translate((float)(-this.mLocationInWindow[0]), (float)(-this.mLocationInWindow[1]));
        this.mCanvas.save();
        this.getRootView().draw(this.mCanvas);
    }
}

