/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.cache;

import com.hoko.blur.api.ITexture;
import com.hoko.blur.opengl.cache.CachePool;
import com.hoko.blur.opengl.texture.TextureFactory;
import com.hoko.blur.opengl.util.Size;

public class TextureCache {
    private CachePool<Size, ITexture> mCache = new CachePool<Size, ITexture>(){

        @Override
        protected ITexture create(Size size) {
            if (size == null) {
                return null;
            }
            return TextureFactory.create(size.width(), size.height());
        }

        @Override
        protected void entryDeleted(ITexture texture) {
            if (texture != null) {
                texture.delete();
            }
        }

        @Override
        protected boolean checkHit(Size size, ITexture texture) {
            return size != null && texture != null && size.width() == texture.width() && size.height() == texture.height();
        }
    };

    private TextureCache() {
    }

    public static TextureCache getInstance() {
        return TextureCacheHolder.INSTANCE;
    }

    public ITexture getTexture(int width, int height) {
        if (this.mCache != null) {
            return this.mCache.get(new Size(width, height));
        }
        return null;
    }

    public void recycleTexture(ITexture texture) {
        if (texture != null) {
            this.mCache.put(texture);
        }
    }

    public void deleteTextures() {
        if (this.mCache != null) {
            this.mCache.evictAll();
        }
    }

    private static class TextureCacheHolder {
        private static final TextureCache INSTANCE = new TextureCache();

        private TextureCacheHolder() {
        }
    }
}

