/*
 * Decompiled with CFR 0.152.
 */
package com.hoko.blur.opengl.cache;

import com.hoko.blur.api.IFrameBuffer;
import com.hoko.blur.opengl.cache.CachePool;
import com.hoko.blur.opengl.framebuffer.FrameBufferFactory;

public class FrameBufferCache {
    private CachePool<Object, IFrameBuffer> mCache = new CachePool<Object, IFrameBuffer>(){

        @Override
        protected IFrameBuffer create(Object key) {
            return FrameBufferFactory.create();
        }

        @Override
        protected boolean checkHit(Object key, IFrameBuffer frameBuffer) {
            return true;
        }

        @Override
        protected void entryDeleted(IFrameBuffer frameBuffer) {
            if (frameBuffer != null) {
                frameBuffer.delete();
            }
        }
    };
    private volatile IFrameBuffer sDisplayFrameBuffer;

    private FrameBufferCache() {
    }

    public static FrameBufferCache getInstance() {
        return FrameBufferCacheHolder.INSTANCE;
    }

    public IFrameBuffer getFrameBuffer() {
        if (this.mCache != null) {
            return this.mCache.get(new Object());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IFrameBuffer getDisplayFrameBuffer() {
        if (this.sDisplayFrameBuffer == null) {
            FrameBufferCache frameBufferCache = this;
            synchronized (frameBufferCache) {
                if (this.sDisplayFrameBuffer == null) {
                    this.sDisplayFrameBuffer = FrameBufferFactory.getDisplayFrameBuffer();
                }
            }
        }
        return this.sDisplayFrameBuffer;
    }

    public void recycleFrameBuffer(IFrameBuffer frameBuffer) {
        if (frameBuffer != null) {
            this.mCache.put(frameBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFrameBuffers() {
        if (this.mCache != null) {
            this.mCache.evictAll();
        }
        FrameBufferCache frameBufferCache = this;
        synchronized (frameBufferCache) {
            if (this.sDisplayFrameBuffer != null) {
                this.sDisplayFrameBuffer.delete();
                this.sDisplayFrameBuffer = null;
            }
        }
    }

    private static class FrameBufferCacheHolder {
        private static final FrameBufferCache INSTANCE = new FrameBufferCache();

        private FrameBufferCacheHolder() {
        }
    }
}

